﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Lottery
{
    /// <summary>
    /// 表示参与抽奖的人物信息
    /// </summary>
    class Person
    {
        public string Name { get; private set; }
        public int BaseGrade { get; private set; }

        private int newGrade = 0;

        public int NewGrade
        {
            get => newGrade;
            set
            {
                OldGrade = newGrade;
                newGrade = value;
            }
        }

        public int OldGrade { get; private set; } = 0;

        /// <summary>
        /// 从文件读取人物信息
        /// </summary>
        /// <returns></returns>
        public static IReadOnlyList<Person> GetPersons()
        {
            string filePath = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "p.csv");
            return File.Exists(filePath) ? File.ReadLines(filePath)
                   .Where(p => !string.IsNullOrEmpty(p)).
                   Select(p => new Person
                   {
                       BaseGrade = int.Parse(p.Split(new []{','})[1]),
                       Name = p.Split(new []{','})[0]
                   }).ToList() 
                : new List<Person>(0);
        }

        public static int GetRandomBaseGrade(int baseGrade)
        {
            var r = new Random(379);
            var bs = new[] {3, 7, 9};

            if (baseGrade % 3 == 0)
            {
                return baseGrade * bs[r.Next(0,2)];
            }

            if (baseGrade % 7 == 0)
            {
                return baseGrade * bs[r.Next(0,2)];
            }

            if (baseGrade % 9 == 0)
            {
                return baseGrade * bs[r.Next(0,2)];
            }

            return baseGrade;
        }
    }
}
