﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net.Http;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Lottery
{
    class Program
    {
        static void Main(string[] args)
        {
            Screen.Init();
            if (!NetConnect.CheckNetConnect())
            {
                Console.WriteLine(Environment.NewLine + "请检查网络连接");
                Console.ReadLine();
                return;
            }
            //最终参与抽奖的人数可能变动，采用读文件方式动态获取
            IReadOnlyList<Person> persons = Person.GetPersons().ToList();
            IReadOnlyList<Lottery> lotteries = Lottery.GetLotteries();
            if (persons.Count == 0)
            {
                Console.WriteLine(Environment.NewLine + "未找到抽奖人员，请在程序生成目录下编写p.txt文件，每个人名占一行");
                Console.ReadLine();
                return;
            }
            Console.Clear();
            Screen.ShowTitle("1024抽奖程序");
            Console.WriteLine(Environment.NewLine + "程序将进行3轮计算，为每个人随机发金币，最终按照所得的金币数由多到少排序，以此分别决定所得的奖项大小，按回车开始运行");
            Console.ReadLine();
            for (int i = 1; i <= 3; i++)
            {
                Console.Clear();
                Screen.ShowTitle("1024抽奖程序");
                Console.WriteLine("...正在计算...");

                //开始计分,该循环表示计分规则
                //获取从www.random.org生成的真随机数
                IReadOnlyList<int> randoms = RandomOrg.GetRandomsAsync(persons.Count).Result;
                for (int j = 0; j < persons.Count; j++)
                {
                    //计分方式1：根据返回的随机数加金币
                    //计分方式2：看命
                    //计分方式3：随即加上一个人的金币，看能否逆袭
                    //其他方式：可在下方对NewGrade属性进行操作
                    persons[j].NewGrade += (randoms[j] +
                                        (Math.Abs(persons[j].GetHashCode() << 1) % persons.Count) +
                                        persons[randoms[j] - 1].OldGrade);

                    if (i == 3 && persons[j].BaseGrade > 0)
                    {
                        persons[j].NewGrade += Person.GetRandomBaseGrade(persons[j].BaseGrade);
                    }
                }

                //计分结束，以下为保存及更新显示
                Console.Clear();
                Screen.ShowTitle("第" + i.ToString() + "轮");
                Screen.ShowGradeList(persons, lotteries.Where(p => p.Level <= 3).Sum(p => p.Count));
                Screen.Show(i, persons, lotteries);
                Console.WriteLine(Environment.NewLine + "按回车继续...");
                Console.ReadLine();
            }
            LotteryResult.SaveResult(persons, lotteries);
            Console.ReadLine();
        }
    }
}
