﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.Http;
using System.Reflection;
using System.Reflection.Emit;
using System.Text;
using System.Threading.Tasks;

namespace Lottery
{
    /// <summary>
    /// 表示真随机数
    /// </summary>
    static class RandomOrg
    {
        /// <summary>
        /// 获取从www.random.org根据大气噪声生成的真随机数列表
        /// </summary>
        /// <param name="length">需要获取的随机数个数</param>
        /// <returns>length长度的随机数集合</returns>
        public static async Task<IReadOnlyList<int>> GetRandomsAsync(int length)
        {
            try
            {
                using (HttpClient httpClient = new HttpClient())
                {
                    httpClient.DefaultRequestHeaders.TryAddWithoutValidation("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3936.0 Safari/537.36 Edg/79.0.301.2");
                    var resp = await httpClient.GetAsync($"https://www.random.org/integers/?num={length}&min=1&max={length}&col=1&base=10&format=plain&rnd=new");
                    if (resp.IsSuccessStatusCode)
                    {
                        string content = await resp.Content.ReadAsStringAsync();
                        return content.Split('\n').Where(p => !string.IsNullOrEmpty(p)).Select(p => int.Parse(p)).ToList();
                    }
                }
            }
            catch (Exception)
            {

            }
            var r = new Random(length);
            return Enumerable.Range(0, length).Select(p => r.Next(1, length + 1)).ToList();
        }
    }
}
