﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;

namespace Lottery
{
    static class Screen
    {
        static List<Person> old = new List<Person>();
        public static void ShowTitle(string title)
        {
            Console.ForegroundColor = ConsoleColor.Cyan;
            Enumerable.Range(0, Console.LargestWindowWidth - 3).ToList().ForEach(p => Console.Write("$"));
            Console.SetCursorPosition(Console.LargestWindowWidth / 2, 1);
            title.ToList().ForEach(p => Console.Write(p));
            Console.SetCursorPosition(0, 2);
            Enumerable.Range(0, Console.LargestWindowWidth - 3).ToList().ForEach(p => Console.Write("$"));
        }

        public static void Show(int i, IReadOnlyList<Person> persons, IReadOnlyList<Lottery> lotteries)
        {
            var temp = persons.OrderByDescending(p => p.NewGrade).ToList();
            if (i == 1)
            {
                old.AddRange(temp);
            }
            else if (i > 1)
            {
                Console.WriteLine();
                var n = temp.Take(lotteries.Where(p => p.Level <= 3).Sum(p => p.Count)).Max(p => old.LastIndexOf(p));
                Console.WriteLine($"逆袭大神：{old[n].Name}");
                n = old.Take(lotteries.Where(p => p.Level <= 3).Sum(p => p.Count))
                       .Max(p => temp.LastIndexOf(p));
                Console.WriteLine();
                Console.WriteLine($"翻车小弟：{persons[n].Name}");
                old.Clear();
                old.AddRange(temp);
            }
        }

        public static void ShowGradeList(IReadOnlyList<Person> person, int highlight)
        {
            var people = person.OrderByDescending(p => p.NewGrade).ToList();
            int width = ((Console.LargestWindowWidth - 6) / 3 - 6) / 3;
            Console.ForegroundColor = ConsoleColor.Yellow;
            var titles = new List<string> { "排名", "人名", "金币" };
            for (int i = 0; i < titles.Count; i++)
            {
                Console.SetCursorPosition(i * width, 5);
                Console.Write(titles[i]);
            }
            var list1 = people.Take(people.Count / 3).ToList();
            int index = 1;
            for (int i = 0; i < list1.Count; i++)
            {
                Console.ForegroundColor = index <= highlight ? ConsoleColor.Yellow : ConsoleColor.White;
                Console.SetCursorPosition(0, i + 6);
                Console.Write($"{index++}");
                Console.SetCursorPosition(width, i + 6);
                Console.Write($"{list1[i].Name}");

                Console.SetCursorPosition(width * 2, i + 6);
                Console.Write($"{list1[i].NewGrade}");
            }
            Console.ForegroundColor = ConsoleColor.Yellow;
            for (int i = 1; i <= titles.Count; i++)
            {
                Console.SetCursorPosition((i - 1) * width + width * 4 - 4, 5);
                Console.Write(titles[i - 1]);
            }
            var list2 = people.Skip(people.Count / 3).Take(people.Count / 3).ToList();
            for (int i = 0; i < list2.Count; i++)
            {
                Console.ForegroundColor = index <= highlight ? ConsoleColor.Yellow : ConsoleColor.White;
                Console.SetCursorPosition(0 + width * 4 - 4, i + 6);
                Console.Write($"{index++}");
                Console.SetCursorPosition(width + width * 4 - 4, i + 6);
                Console.Write($"{list2[i].Name}");
                Console.SetCursorPosition(width * 2 + width * 4 - 4, i + 6);
                Console.Write($"{list2[i].NewGrade}");
            }
            Console.ForegroundColor = ConsoleColor.Yellow;
            for (int i = 1; i <= titles.Count; i++)
            {
                Console.SetCursorPosition((i - 1) * width + width * 8 - 4, 5);
                Console.Write(titles[i - 1]);
            }
            var list3 = people.Skip(people.Count / 3).Skip(people.Count / 3).ToList();
            for (int i = 0; i < list3.Count; i++)
            {
                Console.ForegroundColor = index <= highlight ? ConsoleColor.Yellow : ConsoleColor.White;
                Console.SetCursorPosition(0 + width * 8 - 4, i + 6);
                Console.Write($"{index++}");
                Console.SetCursorPosition(width + width * 8 - 4, i + 6);
                Console.Write($"{list3[i].Name}");
                Console.SetCursorPosition(width * 2 + width * 8 - 4, i + 6);
                Console.Write($"{list3[i].NewGrade}");
            }
        }

        [DllImport("User32.dll", EntryPoint = "FindWindow")]
        private static extern IntPtr FindWindow(string lpClassName, string lpWindowName);

        [DllImport("user32.dll", EntryPoint = "FindWindowEx")]
        private static extern IntPtr FindWindowEx(IntPtr hwndParent, IntPtr hwndChildAfter, string lpszClass, string lpszWindow);

        [DllImport("User32.dll", EntryPoint = "SendMessage")]
        private static extern int SendMessage(IntPtr hWnd, int Msg, IntPtr wParam, string lParam);

        [DllImport("User32.dll", EntryPoint = "ShowWindow")]
        private static extern bool ShowWindow(IntPtr hWnd, int type);

        public static void Init()
        {
            Console.Title = "1024抽奖程序";
            IntPtr ParenthWnd = new IntPtr(0);
            IntPtr et = new IntPtr(0);
            ParenthWnd = FindWindow(null, "1024抽奖程序");
            //最大化
            ShowWindow(ParenthWnd, 3);
            Console.SetWindowSize(Console.LargestWindowWidth, Console.LargestWindowHeight);
            Console.BufferWidth = Console.LargestWindowWidth;
            Console.BufferHeight = Console.LargestWindowHeight * 2;
            Console.WindowLeft = Console.WindowTop = 0;
            Enumerable.Range(0, Console.LargestWindowWidth).ToList().ForEach(p => Enumerable.Range(0, Console.LargestWindowHeight).ToList().ForEach(d => Console.Write("")));
        }
    }
}
