let config = null, viewer = null, vector = null, piontCloud = null, east = null, west = null, model = null,
    ESRIImg = null, TDTVec = null, points = [], polygon = null, polyline = null, handler = null;
let isAnalysisMeasure = false, isAnalysisRoam = false, isLinkageMap = false;
/**
 * 读取配置文件
 */
$.getJSON("Build/Static/config.json", "", function (data) {
    config = data;
    $(document).ready(function () {
        initialize();
    });
});
let bbb = [113.57993929492828, 24.757788614458665, 56.40819703595857,
    113.58042337882382, 24.762011097225702, 57.625067900097754,
    113.58667578710657, 24.77993872920966, 52.85068850308793,
    113.5901687246086, 24.78787272540614, 68.66440876067267,
    113.58253622416856, 24.79075774131515, 55.37193855413751,
    113.58209351318378, 24.789670171921866, 54.752270309579636,
    113.58140475962021, 24.787852214603156, 54.90525519745283,
    113.5803755036816, 24.78655830368518, 63.47664080306659,
    113.57950006317061, 24.78503239838254, 86.16133594293437,
    113.5785904739769, 24.782924274707476, 55.74207512634407,
    113.57737032179502, 24.7800375246563, 70.48456322340085,
    113.57694221126876, 24.778524193046145, 64.52791904461692,
    113.57673062172505, 24.77783258653857, 61.845324096965065,
    113.57683432596275, 24.776689379516608, 52.78622229219828,
    113.57695701291811, 24.77676645668354, 53.60485601755412,
    113.57652008176079, 24.774583670236865, 52.914322843730844,
    113.57618325503643, 24.773482647876065, 53.12024365570671,
    113.57573672271162, 24.772629217577702, 53.307174705622984,
    113.5750161596855, 24.771174858506647, 53.52368761451272,
    113.57486944958417, 24.770761560881795, 54.38952838245314,
    113.57428981783328, 24.768565890145645, 56.21005542609739,
    113.57400330110055, 24.766088991832202, 54.525206398174156,
    113.5717923185076, 24.75931185268254, 58.73210473092085];

/**
 * 初始化场景
 */
function initialize() {
    let ESRIImg = new Cesium.ArcGisMapServerImageryProvider({
        name: config.ESRIImg.name,
        url: config.ESRIImg.url,
        layer: config.ESRIImg.layer,
        style: config.ESRIImg.style,
        format: config.ESRIImg.format,
        tileMatrixSetID: config.ESRIImg.tileMatrixSetID,
        minimumLevel: config.ESRIImg.minimumLevel,
        maximumLevel: config.ESRIImg.maximumLevel,
        enablePickFeatures: config.ESRIImg.enablePickFeatures,
    });
    viewer = new Cesium.Viewer('mainScene', {
        sceneMode: Cesium.SceneMode.SCENE3D,
        scene3DOnly: true,
        fullscreenButton: false,
        homeButton: false,
        animation: false,
        baseLayerPicker: false,
        geocoder: false,
        timeline: false,
        sceneModePicker: false,
        navigationHelpButton: false,
        selectionIndicator: false,
        infoBox: false,
        imageryProvider: ESRIImg,
        contextOptions: {
            webgl: {
                alpha: true,
                depth: false,
                stencil: true,
                antialias: true,
                premultipliedAlpha: true,
                preserveDrawingBuffer: true,
                failIfMajorPerformanceCaveat: true
            }
        }
    });
    Cesium.viewerCesiumNavigationMixin(viewer, {
        enableCompass: true,
        enableZoomControls: true,
        enableDistanceLegend: true,
        enableCompassOuterRing: true,
        defaultPositionView: {
            destination: new Cesium.Cartesian3.fromDegrees(config.InitialPosition.lon, config.InitialPosition.lat, config.InitialPosition.height),
            orientation: new Cesium.HeadingPitchRoll.fromDegrees(config.InitialOrientation.heading, config.InitialOrientation.pitch, config.InitialOrientation.roll)
        }
    });
    viewer.terrainProvider = new Cesium.CesiumTerrainProvider({
        url: config.Terrain,
        requestWaterMask: false,
        requestVertexNormals: false
    });
    east = add3Dtile(config.MainModelData.east.url, config.MainModelData.east.matrix);
    west = add3Dtile(config.MainModelData.west.url, config.MainModelData.west.matrix);
    vector = add3Dtile(config.MainModelData.vector.url, config.MainModelData.vector.matrix);
    piontCloud = add3Dtile(config.MainModelData.cloud.url, config.MainModelData.cloud.matrix);
    for (let i = 0; i < bbb.length; i += 3) {
        points.push(viewer.entities.add({
            name: "点" + (i / 3 + 1),
            position: new Cesium.Cartesian3.fromDegrees(bbb[i], bbb[i + 1], bbb[i + 2]),
            point: {
                show: true,
                color: Cesium.Color.SKYBLUE,
                pixelSize: 8,
                outlineColor: Cesium.Color.BLUE,
                outlineWidth: 3,
            },
            show: false
        }));
    }
    polygon = new Cesium.GroundPrimitive({
        geometryInstances: new Cesium.GeometryInstance({
            geometry: new Cesium.CorridorGeometry({
                vertexFormat: Cesium.VertexFormat.POSITION_ONLY,
                positions: Cesium.Cartesian3.fromDegreesArrayHeights(bbb),
                width: 20
            }),
            attributes: {
                color: Cesium.ColorGeometryInstanceAttribute.fromColor(Cesium.Color.fromAlpha(Cesium.Color.YELLOW, 0.8))
            }
        }),
        appearance: new Cesium.PerInstanceColorAppearance({
            translucent: true,
            closed: true,
            aboveGround: true
        }),
        classificationType: Cesium.ClassificationType.BOTH,
        show: false
    });
    polyline = new Cesium.GroundPrimitive({
        geometryInstances: new Cesium.GeometryInstance({
            geometry: new Cesium.CorridorGeometry({
                vertexFormat: Cesium.VertexFormat.POSITION_ONLY,
                positions: Cesium.Cartesian3.fromDegreesArrayHeights(bbb),
                width: 1
            }),
            attributes: {
                color: Cesium.ColorGeometryInstanceAttribute.fromColor(Cesium.Color.fromAlpha(Cesium.Color.RED, 1))
            }
        }),
        appearance: new Cesium.PerInstanceColorAppearance({
            translucent: true,
            closed: true,
            aboveGround: true
        }),
        classificationType: Cesium.ClassificationType.BOTH,
        show: false
    });
    viewer.scene.moon.show = false;
    viewer.scene.primitives.add(polygon);
    viewer.scene.primitives.add(polyline);
    viewer.scene.globe.depthTestAgainstTerrain = true;
    viewer.cesiumWidget.creditContainer.style.display = "none";
    viewer.scene.screenSpaceCameraController.enableLook = false;
    viewer.scene.screenSpaceCameraController.enableTranslate = false;
    viewer.scene.globe.baseColor = Cesium.Color.fromCssColorString(config.globe.baseColor);
    viewer.scene.screenSpaceCameraController.zoomEventTypes = [Cesium.CameraEventType.WHEEL, Cesium.CameraEventType.PINCH];
    viewer.scene.screenSpaceCameraController.tiltEventTypes = [Cesium.CameraEventType.RIGHT_DRAG, Cesium.CameraEventType.PINCH]
    viewer.cesiumWidget.screenSpaceEventHandler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_DOUBLE_CLICK);
    viewer.camera.setView({
        destination: new Cesium.Cartesian3.fromDegrees(config.InitialPosition.lon, config.InitialPosition.lat, config.InitialPosition.height),
        orientation: new Cesium.HeadingPitchRoll.fromDegrees(config.InitialOrientation.heading, config.InitialOrientation.pitch, config.InitialOrientation.roll)
    });
    // console.log(viewer.scene.sampleHeight(new Cesium.Cartographic(1.9823439049117852, 0.4321049268350687)));
    mapMeasure();
    mapRoam();
    viewer.popup = new Popup(viewer);
    let downHandler = new Cesium.ScreenSpaceEventHandler(viewer.scene.canvas);
    downHandler.setInputAction(function (movement) {
        let cartesian = viewer.scene.pickPosition(movement.position);
        let pickedObject = viewer.scene.pick(movement.position);
        if (Cesium.defined(pickedObject)) {
            if (Cesium.defined(pickedObject["id"])) {
                // console.log(pickedObject["id"].name);
                viewer.popup.show(cartesian, {name: pickedObject["id"].name});
            }
        }
    }, Cesium.ScreenSpaceEventType.LEFT_DOWN);
}

function add3Dtile(url, matrix) {
    return viewer.scene.primitives.add(new Cesium.Cesium3DTileset({
        url: url,
        modelMatrix: matrix,
        maximumMemoryUsage: 300,
    }));
}

function setVisiable(node, checked) {
    switch (node.id) {
        case 11:
            east.show = checked;
            break;
        case 12:
            west.show = checked;
            break;
        case 21:
            piontCloud.show = checked;
            break;
        case 31:
            vector.show = checked;
            break;
        case 41:
            polyline.show = checked;
            break;
        case 51:
            polygon.show = checked;
            break;
    }
    if (node.id > 600 && node.id < 700) {
        points[node.id % 600 - 1].show = checked;
    }
}

function mapMeasure() {
    if (isAnalysisMeasure) {
        Clean();
        viewer.mapMeasure = null;
    } else {
        viewer.mapMeasure = new MapMeasure(viewer);
    }
    isAnalysisMeasure = !isAnalysisMeasure
}

function startRoams() {
    viewer.popup.close();
    viewer.roamAnalysis.loadDefaultRoamRoad(bbb);
    viewer.roamAnalysis.startRoam();
}

function stopRoams() {
    viewer.roamAnalysis.stopRoam(name);
    viewer.roamAnalysis.Clean();
}

function startPolygon() {
    viewer.mapMeasure.AreaMeasure("measure-polygon");
}

function startPolyline() {
    viewer.mapMeasure.LinearMeasure("measure-polyline");
}

function Clean() {
    viewer.mapMeasure.Clean();
}

function mapRoam() {
    if (isAnalysisRoam) {
        viewer.roamAnalysis = null;
    } else {
        viewer.roamAnalysis = new Roam(viewer);
    }
    isAnalysisRoam = !isAnalysisRoam;
}

function mapLinkage() {
    if (isLinkageMap) {
        endLinkageMap();
    } else {
        startLinkageMap();
    }
    isLinkageMap = !isLinkageMap;
}

function startLinkageMap() {
    viewer.linkageby2D3D = new Linkage(viewer, config.linkageby2D3D);
    viewer.linkageby2D3D.spiltScreen();
}

function endLinkageMap() {
    viewer.linkageby2D3D.reset()
    viewer.linkageby2D3D = null;

}


function cartesian2LonLat(cartesian) {
    let cartographic = Cesium.Cartographic.fromCartesian(cartesian);
    let lon = Cesium.Math.toDegrees(cartographic.longitude);
    let lat = Cesium.Math.toDegrees(cartographic.latitude);
    return [lon, lat, cartographic.height];
}