$(document).ready(function () {
    /**
     * 工具条点击事件
     */
    $('.tooldrop').click(function () {
        let id = $(this).attr("id").replace('tool', 'bar');
        switch (id) {
            case"bar_clean":
                Clean();
                break;
            case"bar_polygon":
                startPolygon();
                break;
            case"bar_polyline":
                startPolyline();
                break;
            case"bar_start":
                startRoams();
                break;
            case"bar_end":
                stopRoams();
                break;
        }
        if (id === "bar_layer") {
            if ($(".show").attr("id") !== id) {
                $(".show").removeClass("show");
            }
            if ($('.active').attr("id") !== $(this).attr("id")) {
                $(".active").removeClass("active");
            }
            if ($(this).hasClass('active')) {
                $('.' + id).removeClass('show');
                $(this).removeClass('active');
            } else {
                $('.' + id).addClass('show');
                $(this).addClass('active');
            }
        }
    });

    $('.linkage').click(function () {
        mapLinkage();
        console.log("============");
    });

    /**
     * 工具条按钮点击事件
     */
    $('.toolbtn').click(function () {
        let id = $(this).attr("id");
        switch (id) {
            case "tool_home":
                flyToHome();
                break;
            case "tool_north":
                setNorth();
                break;
            case "tool_full":
                if ($(this).hasClass('full')) {
                    exitFullscreen(document.getElementById("mainscene"));
                    $(this).removeClass('full');
                } else {
                    launchIntoFullscreen(document.getElementById("mainscene"));
                    $(this).addClass('full');
                }
                break;
            case "tool_export":
                saveScene();
                break;
        }
    });
    /**
     * 全景按钮点击事件
     */
    $('.toolpanorama').click(function () {
        if ($(this).hasClass('panorama')) {
            setPanorama(false);
            $('.toolbtn').show();
            $(this).removeClass('panorama');
        } else {
            setPanorama(true);
            $('.toolbtn').hide();
            $(this).addClass('panorama');
        }
    });

    /**
     * 图层树
     */
    $('#tree_layer').tree({
        data: [
            {
                "id": 1,
                "text": "倾斜摄影",
                "iconCls": "icon-file",
                "children": [
                    {
                        "id": 11,
                        "text": "east",
                        "checked": true
                    },
                    {
                        "id": 12,
                        "text": "west",
                        "checked": true
                    }
                ]
            },
            {
                "id": 2,
                "text": "点云数据",
                "iconCls": "icon-file",
                "children": [
                    {
                        "id": 21,
                        "text": "示例数据",
                        "checked": true
                    }
                ]
            },
            {
                "id": 3,
                "text": "人工模型",
                "iconCls": "icon-file",
                "children": [
                    {
                        "id": 31,
                        "text": "测试数据",
                        "checked": true
                    },
                ]
            },
            {
                "id": 4,
                "text": "矢量线",
                "iconCls": "icon-file",
                "children": [
                    {
                        "id": 41,
                        "text": "测试数据",
                        "checked": false
                    }
                ]
            },
            {
                "id": 5,
                "text": "矢量",
                "iconCls": "icon-file",
                "children": [
                    {
                        "id": 51,
                        "text": "测试数据",
                        "checked": false
                    }
                ]
            }, {
                "id": 6,
                "text": "点集",
                "iconCls": "icon-file",
                "children": [
                    {
                        "id": 601,
                        "text": "点1",
                        "checked": false
                    },
                    {
                        "id": 602,
                        "text": "点2",
                        "checked": false
                    },
                    {
                        "id": 603,
                        "text": "点3",
                        "checked": false
                    },
                    {
                        "id": 604,
                        "text": "点4",
                        "checked": false
                    },
                    {
                        "id": 605,
                        "text": "点5",
                        "checked": false
                    },
                    {
                        "id": 606,
                        "text": "点6",
                        "checked": false
                    },
                    {
                        "id": 607,
                        "text": "点7",
                        "checked": false
                    },
                    {
                        "id": 608,
                        "text": "点8",
                        "checked": false
                    },
                    {
                        "id": 609,
                        "text": "点9",
                        "checked": false
                    },
                    {
                        "id": 610,
                        "text": "点10",
                        "checked": false
                    },
                    {
                        "id": 611,
                        "text": "点11",
                        "checked": false
                    },
                    {
                        "id": 612,
                        "text": "点12",
                        "checked": false
                    },
                    {
                        "id": 613,
                        "text": "点13",
                        "checked": false
                    },
                    {
                        "id": 614,
                        "text": "点14",
                        "checked": false
                    },
                    {
                        "id": 615,
                        "text": "点15",
                        "checked": false
                    },
                    {
                        "id": 616,
                        "text": "点16",
                        "checked": false
                    },
                    {
                        "id": 617,
                        "text": "点17",
                        "checked": false
                    },
                    {
                        "id": 618,
                        "text": "点18",
                        "checked": false
                    },
                    {
                        "id": 619,
                        "text": "点19",
                        "checked": false
                    },
                    {
                        "id": 620,
                        "text": "点20",
                        "checked": false
                    },
                    {
                        "id": 621,
                        "text": "点21",
                        "checked": false
                    },
                    {
                        "id": 622,
                        "text": "点22",
                        "checked": false
                    },
                    {
                        "id": 623,
                        "text": "点23",
                        "checked": false
                    }
                ]

            }
        ],
        onlyLeafCheck: true,
        onCheck: function (node, checked) {
            setVisiable(node, checked);

        }
    })

});