function ClearanceAnalysis(viewer) {
    let _self = this;
    _self.isDraw = false;
    _self.points = [];
    _self.polylinePath = [];
    _self.polyline = null;
    _self.line = null;
    _self.handler = viewer.cesiumWidget.screenSpaceEventHandler;
    _self.handler.removeInputAction(Cesium.ScreenSpaceEventType.MOUSE_MOVE);
    _self.handler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_CLICK);

    let CreatePolyline = (function () {
        function _(positons) {
            this.line = {
                polyline: {
                    show: true,
                    width: 5,
                    material: new Cesium.PolylineOutlineMaterialProperty({
                        color: Cesium.Color.AQUA,
                        outlineColor: Cesium.Color.AQUA
                    }),
                    depthFailMaterial: new Cesium.PolylineOutlineMaterialProperty({
                        color: Cesium.Color.AQUA,
                        outlineColor: Cesium.Color.AQUA
                    }),
                }
            };
            this.path = positons;
            this._init();
        }

        _.prototype._init = function () {
            let that = this;
            let positionCBP = function () {
                return that.path;
            };
            this.line.polyline.positions = new Cesium.CallbackProperty(positionCBP, false);
            _self.line = viewer.entities.add(this.line);
        };
        return _;
    })();

    function getHight(max, min) {
        return Cesium.Cartographic.fromCartesian(max).height - Cesium.Cartographic.fromCartesian(min).height;
    }

    function getClearance() {
        let maxPoint = null, minPoint = null;
        if (_self.points[1].z > _self.points[0].z) {
            maxPoint = _self.points[1];
            minPoint = _self.points[0];
        } else {
            maxPoint = _self.points[0];
            minPoint = _self.points[1];
        }
        let ax = maxPoint[0], ay = maxPoint[1], az = maxPoint[2], bx = minPoint[0],
            by = minPoint[1], bz = minPoint[2];
        addLine(ax, ay, az, bx, by, bz);
        addLine(ax, ay, az, ax, by, az);
        // addLine(ax, ay, az, bx, ay, az);
        addLine(ax, ay, az, bx, by, az);
        // addLine(bx, ay, az, bx, by, az);
        addLine(ax, by, az, bx, by, az);
        addLine(bx, by, az, bx, by, bz);
        // addLine(ax, ay, az, bx, by, bz);
        // addLine(ax, ay, az, ax, by, az);
        // addLine(bx, by, bz, ax, by, az);
    }

    function addLine(ax, ay, az, bx, by, bz) {
        viewer.entities.add({
            polyline: {
                positions: Cesium.Cartesian3.fromDegreesArrayHeights([ax, ay, az,
                    bx, by, bz]),
                width: 4,
                material: new Cesium.PolylineOutlineMaterialProperty({
                    color: Cesium.Color.YELLOW,
                    outlineColor: Cesium.Color.YELLOW
                })
            }
        });
        viewer.entities.add({
            position: Cesium.Cartesian3.fromDegrees((ax + bx) / 2, (ay + by) / 2, (az + bz) / 2),
            label: {
                text: Cesium.Cartesian3.distance(new Cesium.Cartesian3.fromDegrees(ax, ay, az), new Cesium.Cartesian3.fromDegrees(bx, by, bz)).toFixed(2).toString() + "米",
                font: '24px Helvetica',
                fillColor: Cesium.Color.YELLOW,
                horizontalOrigin: Cesium.HorizontalOrigin.CENTER,
                pixelOffset: new Cesium.Cartesian2(0.0, -10)
            }
        });
    }

    function cartesian2LonLat(cartesian) {
        let cartographic = Cesium.Cartographic.fromCartesian(cartesian);
        let lon = Cesium.Math.toDegrees(cartographic.longitude);
        let lat = Cesium.Math.toDegrees(cartographic.latitude);
        return [lon, lat, cartographic.height];
    }

    ClearanceAnalysis.prototype.startDraw = function () {
        _self.isDraw = true;
        _self.handler.setInputAction(function (movement) {
            if (_self.isDraw) {
                let cartesian = viewer.scene.pickPosition(movement.position);
                if (cartesian) {
                    _self.polylinePath.push(cartesian);
                    _self.points.push(cartesian2LonLat(cartesian));
                    if (_self.points.length === 2) {
                        _self.stopDraw();
                        viewer.entities.removeAll();
                        $(('#measure-polyline-svg')).css('fill', '#ffffff');
                        getClearance();
                    }
                }
            }
        }, Cesium.ScreenSpaceEventType.LEFT_CLICK);
        _self.handler.setInputAction(function (movement) {
            if (_self.isDraw) {
                let cartesian = viewer.scene.pickPosition(movement.endPosition);
                if (cartesian) {
                    if (_self.polylinePath.length < 1) {
                        return;
                    }
                    if (!Cesium.defined(_self.polyline)) {
                        _self.polylinePath.push(cartesian);
                        _self.polyline = new CreatePolyline(_self.polylinePath);
                    } else {
                        _self.polyline.path.pop();
                        _self.polyline.path.push(cartesian);
                    }
                }
            }
        }, Cesium.ScreenSpaceEventType.MOUSE_MOVE);
    };

    ClearanceAnalysis.prototype.stopDraw = function () {
        _self.isDraw = false;
        _self.handler.removeInputAction(Cesium.ScreenSpaceEventType.MOUSE_MOVE);
        _self.handler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_CLICK);
    };
    ClearanceAnalysis.prototype.clean = function () {
        _self.polylinePath = [];
        _self.polyline = null;
        _self.points = [];
        viewer.entities.removeAll();
    };

    ClearanceAnalysis.prototype.getLines = function () {
        return _self.polylinePath;
    }
}