/**
 * 控高分析
 * @param viewer 场景主视图
 * @param data 场景白模模型数据
 * @param baseHeight 场景初始化高度
 * @param option 参数设置信息
 * @constructor
 */
function HeightAnalysis(viewer, data, baseHeight, option) {
    let _self = this;
    _self.url = option.url;
    _self.typeName = option.typeName;
    _self.viewer = viewer;
    _self.data = data;
    _self.baseHeight = baseHeight;
    _self.height = 10;
    _self.polygon = [];
    _self.txt = "";
    _self.startP = "";
    _self.drawHelper = new DrawGeometryHelper(viewer);
    _self.drawLayer = new Cesium.PrimitiveCollection();
    _self.viewer.scene.primitives.add(_self.drawLayer);

    /**
     * 绘制控高范围
     * @param name
     * @constructor
     */
    function DrawGeometry(name) {
        _self.drawHelper.startDrawingPolygon({
            callback: function (position, state) {
                _self.polygon.push(position);
                let p = cartesian2LonLat(position);
                if (_self.txt === "") {
                    _self.startP = p[0] + " " + p[1];
                }
                _self.txt += p[0] + " " + p[1] + "\\,";
                if (state === "drawEnd") {
                    _self.txt += _self.startP;
                    var primitive = new Cesium.Primitive({
                        id: "polygon",
                        geometryInstances: new Cesium.GeometryInstance({
                            geometry: new Cesium.PolygonGeometry({
                                polygonHierarchy: {
                                    positions: _self.polygon,
                                },
                                vertexFormat: Cesium.PerInstanceColorAppearance.VERTEX_FORMAT,
                                height: 437,
                                extrudedHeight: 436.0,
                            }),
                        }),
                        appearance: new Cesium.PerInstanceColorAppearance({
                            translucent: true,
                            closed: true,
                            aboveGround: true,
                        }),
                    });
                    // _self.drawLayer.add(primitive);
                    getId(_self.txt);
                    closeCSS(name);
                }
            },
        });
    }

    /**
     * 获取范围内的模型id
     * @param txt
     */
    function getId(txt) {
        $.ajax({
            type: 'get',
            url: _self.url,
            data: {
                'service': 'wfs',
                'version': '1.0.0',
                'request': 'GetFeature',
                'typeName': _self.typeName,
                'maxFeatures': '100000',
                'outputFormat': 'application/json',
                'viewparams': 's\:' + txt
            },
            success: function (data) {
                let txt = "";
                for (let i = 0; i < data.features.length - 1; i++) {
                    txt += "(${Id} === " + data.features[i].properties.id + ") || ";
                }
                txt += "(${Id} === " + data.features[data.features.length - 1].properties.id + ")";
                setHeightStyle(txt);
            }
        });
    }

    /**
     * 平面坐标转经纬度坐标
     * @param cartesian
     * @returns {*[]}
     */
    function cartesian2LonLat(cartesian) {
        var cartographic = Cesium.Cartographic.fromCartesian(cartesian);
        var lon = Cesium.Math.toDegrees(cartographic.longitude);
        var lat = Cesium.Math.toDegrees(cartographic.latitude);
        var height = cartographic.height;
        return [lon, lat];
    }

    /**
     * 根据高度动态设置白模显示样式
     * @param txt
     */
    function setHeightStyle(txt) {
        _self.data.style = new Cesium.Cesium3DTileStyle({
            color: {
                conditions: [
                    ["((${height}+ ${altitude}) <= " + _self.height + ")", "color('lime', 0.3)"],
                    ["((${height}+ ${altitude}) > " + _self.height + ")", "color('red', 0.3)"]
                ],

            },
            show: txt,
        });
    }

    /**
     * 关闭css
     * @param name
     */
    function closeCSS(name) {
        $(('#' + name + "-svg")).css('fill', '#ffffff');
        $('.height').removeClass('height');
    }

    /**
     * 设置控高高度值
     * @param height
     */
    HeightAnalysis.prototype.setHeight = function (height) {
        _self.height = height;
    };
    /**
     * 绘制控高范围
     * @param id
     */
    HeightAnalysis.prototype.drawGeometry = function (id) {
        DrawGeometry(id);
    };
    /**
     * 清除控高分析
     */
    HeightAnalysis.prototype.clean = function () {
        _self.txt = "";
        _self.polygon = [];
        _self.drawLayer.removeAll();
        _self.drawHelper.stopDrawing();
        _self.data.style = new Cesium.Cesium3DTileStyle({
            color: " color('transparent', 0.01)",
        });
    };
}