/**
 * 二三维联动和鹰眼分析
 * @param viewer 场景主视图
 * @param option 参数设置
 * @constructor
 */
function Linkageby2D3D(viewer, option) {
    let _self = this;
    _self.scene = viewer;
    _self.map = null;
    _self.height = option.height > 0 ? option.height : 0;
    _self.isFocus3D = true;
    _self.option = option;
    _self.isHawkEye = option.isHawkEye;
    _self.controlsHide = option.controlsHide;
    /**
     * 移动三维场景
     */
    function sync3DView() {
        if (_self.isFocus3D) return;
        let scratchOffset = new Cesium.Cartesian3();
        const position = _self.map.scene.globe.ellipsoid.cartographicToCartesian(_self.map.scene.camera.positionCartographic);
        if (!Cesium.defined(position)) {
            return
        }
        scratchOffset.z = _self.map.scene.camera.positionCartographic.height + _self.height;
        _self.scene.camera.flyTo({
            destination: position,
            orientation: scratchOffset
        })
    }
    /**
     * 移动二维地图
     */
    function sync2Dmap() {
        _self.scene.camera.percentageChanged = 0.01;
        if (!_self.isFocus3D) return;
        let distance;
        let viewCenter = new Cesium.Cartesian2(Math.floor(_self.map.canvas.clientWidth / 2), Math.floor(_self.map.canvas.clientHeight / 2));
        let worldPosition = _self.scene.scene.camera.pickEllipsoid(viewCenter);
        if (!Cesium.defined(worldPosition)) {
            return
        }
        distance = _self.scene.camera.positionCartographic.height + _self.height;
        _self.map.entities.removeAll();
        let point = _self.map.entities.add({
            show: true,
            position: worldPosition,
            point: {
                pixelSize: 1,
                color: Cesium.Color.WHITE,
                outlineWidth: 0
            }
        })
        _self.map.zoomTo(point, new Cesium.HeadingPitchRange(0, 0, distance))
    }
    /**
     * 获得当前三维场景焦点
     */
    $('.' + _self.option.mainScene).click(function () {
        _self.isFocus3D = true;
    });
    /**
     * 获得当前二维地图焦点
     */
    $('.' + _self.option.container).click(function () {
        _self.isFocus3D = false;
    });
    /**
     * 动态分屏
     */
    Linkageby2D3D.prototype.spiltScreen = function () {
        if (!_self.isHawkEye) {
            for (let i = 0; i < _self.controlsHide.length; i++) {
                $(_self.controlsHide[i]).hide();
            }
            $('.' + _self.option.mainScene).width('50%');
            $('.' + _self.option.container).show();
        } else {
            $('.' + _self.option.container).show();
        }
        _self.map = new Cesium.Viewer(_self.option.container, {
            sceneMode: Cesium.SceneMode.SCENE2D,
            scene3DOnly: true,
            fullscreenButton: false,
            homeButton: false,
            animation: false,
            baseLayerPicker: false,
            geocoder: false,
            timeline: false,
            sceneModePicker: false,
            navigationHelpButton: false,
            selectionIndicator: false,
            infoBox: false,
            contextOptions: {
                webgl: {
                    alpha: true,
                    depth: false,
                    stencil: true,
                    antialias: true,
                    premultipliedAlpha: true,
                    preserveDrawingBuffer: true,
                    failIfMajorPerformanceCaveat: true
                }
            },
            imageryProvider: new Cesium.WebMapTileServiceImageryProvider({
                url: _self.option.baseLayer.url,
                layer: _self.option.baseLayer.layer,
                style: _self.option.baseLayer.style,
                format: _self.option.baseLayer.format,
                tileMatrixSetID: _self.option.baseLayer.tileMatrixSetID,
            })
        });
        _self.map.cesiumWidget.creditContainer.style.display = "none";
        _self.scene.camera.changed.addEventListener(sync2Dmap);
        _self.map.camera.changed.addEventListener(sync3DView);
        _self.scene.camera.changed.raiseEvent(sync2Dmap);

    };
    /**
     * 重置当前屏幕
     */
    Linkageby2D3D.prototype.reset = function () {
        if (!_self.isHawkEye) {
            for (let i = 0; i < _self.controlsHide.length; i++) {
                $(_self.controlsHide[i]).show();
            }
            $('.' + _self.option.mainScene).width('100%');
            $('.' + _self.option.container).hide();
        } else {
            $('.' + _self.option.container).hide();
        }
        _self.scene.camera.changed.removeEventListener(sync2Dmap);
        _self.map.camera.changed.removeEventListener(sync3DView);
        _self.map.destroy();
    }
}