/**
 * 位置查询
 * @param viewer 地图主视图
 * @param option 查询参数
 * @constructor
 */
function LocationQuery(viewer, option) {
    let _self = this;
    _self.result = null;
    _self.viewer = viewer;
    _self.url = option.url;
    _self.token = option.token;
    _self.listID = option.listID;
    _self.inputID = option.inputID;
    _self.location = null;
    /**
     * 绑定输入事件
     */
    $(document).ready(function () {
        let serachtimer;
        $(_self.inputID).change(function () {
            clearTimeout(serachtimer);
            let input_select = $(_self.inputID).val();
            let option_length = $("option").length;
            let option_id = '', option_value = '', option_label = '', lon = null, lat = null;
            for (let i = 0; i < option_length; i++) {
                option_value = $("option").eq(i).attr('value');
                if (input_select === option_value) {
                    option_id = $("option").eq(i).attr('id');
                    option_label = $("option").eq(i).attr('label');
                    lon = _self.result[6].location.lng;
                    lat = _self.result[6].location.lat;
                    flyToEntity(lon, lat);
                    break;
                }
            }
            console.log(input_select, option_label, option_id, lon, lat);
        });
        $(_self.inputID).bind("input propertychange", function () {
            clearTimeout(serachtimer);
            serachtimer = setTimeout(function () {
                console.log($(_self.inputID).val());
                if ($(_self.inputID).val().trim() === '') {
                    console.log('text is empty');
                } else {
                    $.ajax({
                        url: 'http://api.map.baidu.com/place/v2/suggestion?query=' + $(_self.inputID).val() + '&region=ALL&output=json&ak=dFS3zjvSFiCjYN8auETE2TvUxp6wfeBQ&callback=jsonp_1ec397240a1c930',
                        type: 'get',
                        async: true,
                        dataType: 'jsonp',
                        success: function (datas) {
                            if (datas.result.length > 0) {
                                $(_self.listID).children().remove();
                                _self.result = datas.result;
                                for (let i = 0; i < datas.result.length; i++) {
                                    let data = datas.result[i];
                                    $(_self.listID).append('<option id=' + i + ' class="list" label="' + data.province + data.city + data.district + '" value="' + data.name + '"></option>');
                                }
                            }
                        },
                    })
                }
            }, 500)
        });
    });

    /**
     * 快速跳转到坐标
     * @param lon
     * @param lat
     */
    function flyToEntity(lon, lat) {
        if (_self.location) {
            _self.viewer.entities.remove(_self.location);
            _self.location = null;
        }
        console.log(lon, lat);
        let height = viewer.scene.globe.getHeight(Cesium.Cartographic.fromCartesian(new Cesium.Cartesian3.fromDegrees(lon, lat)));
        if (height < 0) {
            height = 0;
        }
        _self.location = _self.viewer.entities.add({
            id: "test",
            position: new Cesium.Cartesian3.fromDegrees(lon, lat, height),
            billboard: {
                pixelOffset: new Cesium.Cartesian2(0, 0),
                eyeOffset: new Cesium.Cartesian3(0.0, 0.0, -30.0),
                horizontalOrigin: Cesium.HorizontalOrigin.CENTER,
                verticalOrigin: Cesium.VerticalOrigin.BOTTOM,
                width: 30,
                height: 30,
                image: "data:image/svg+xml,<svg t=\"1537323945478\" class=\"icon\" style=\"\" viewBox=\"0 0 1024 1024\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" p-id=\"1087\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" width=\"1024\" height=\"1024\"><defs><style type=\"text/css\"></style></defs><path d=\"M512 599.9c-90.4 0-164-73.6-164-164s73.6-164 164-164 164 73.6 164 164-73.5 164-164 164z m0-252.3c-48.7 0-88.3 39.6-88.3 88.3s39.6 88.3 88.3 88.3 88.3-39.6 88.3-88.3-39.6-88.3-88.3-88.3z\" fill=\"#29CCB6\" p-id=\"1088\"></path><path d=\"M512 991c-11.9 0-23.7-4.2-33.3-12.5-37.9-33.2-370.6-330.6-370.6-542.6 0-222.7 181.2-403.8 403.8-403.8s403.8 181.1 403.8 403.8c0 211.9-332.6 509.4-370.6 542.6-9.3 8.3-21.2 12.5-33.1 12.5z m0-858c-167 0-302.9 135.9-302.9 302.9 0 115.2 173.8 316.3 302.8 436.5 107.7-100.9 303-309.9 303-436.5 0-167-135.8-302.9-302.9-302.9z\" fill=\"#4585F5\" p-id=\"1089\"></path></svg>",//'./Build/Cesium/ThirdParty/Draw/img/glyphicons_242_google_maps.png',
                disableDepthTestDistance: Number.POSITIVE_INFINITY
            }
        });
        _self.viewer.zoomTo(_self.location);
    }
}