/**
 * 场景popup弹框
 * @param viewer 场景主视图
 * @constructor
 */
function Popup(viewer) {
    let _self = this;
    _self.data = null;
    _self.viewer = viewer;
    _self.isShow = false;
    _self.position = null;
    _self.overlay = null;
    _self.content = null;
    _self.contentTxT = null;
    create();

    /**
     * 初始化popup框
     */
    function create() {
        _self.viewer = viewer;
        _self.overlay = document.createElement("div");
        _self.overlay.id = "overlay";
        _self.overlay.style.cssText = "position: absolute;display:none";
        var popup = document.createElement("div");
        popup.style.cssText = "position: absolute;background-color: white;-webkit-filter: drop-shadow(0 1px 4px rgba(0, 0, 0, 0.2));filter: drop-shadow(0 1px 4px rgba(0, 0, 0, 0.2));padding: 15px;border-radius: 10px;border: 1px solid #cccccc;bottom: 12px;left: -50px;min-width: 280px; ";
        var content = document.createElement("div");
        content.id = "ol-popup";
        var close = document.createElement('a');
        close.style.cssText = "text-decoration: none;position: absolute;top: 2px;right: 8px;";
        close.id = "popup-closer";
        close.onclick = function () {
            _self.close();
        };
        var closeTxT = document.createTextNode("✖");
        var contentDiv = document.createElement("div");
        contentDiv.id = "popup-content";
        _self.content = document.createElement("label");
        _self.content.id = "position";
        close.appendChild(closeTxT);
        contentDiv.appendChild(close);
        content.appendChild(contentDiv);
        content.appendChild(_self.content);
        popup.appendChild(content);
        _self.overlay.appendChild(popup);
        document.body.appendChild(_self.overlay);
        var css = "#ol-popup:before{top: 100%;border: solid transparent;content: '  ';height: 0;width: 0;position: absolute;pointer-events: none;border-top-color: white;margin-left: 30px;}";
        var style = document.createElement("style");
        style.type = "text/css";
        try {
            style.appendChild(document.createTextNode(css));
        } catch (ex) {
            style.styleSheet.cssText = css;
        }
        close.appendChild(style);
    }

    /**
     * popup始终面向屏幕
     */
    _self.viewer.scene.preRender.addEventListener(function () {
        if (_self.isShow) {
            if (_self.position) {
                _self.content.innerText = _self.contentTxT;
                let position = viewer.scene.cartesianToCanvasCoordinates(_self.position);
                if (position) {
                    _self.overlay.style.top = position.y - _self.overlay.offsetHeight + 'px';
                    _self.overlay.style.left = position.x + 'px';
                    _self.overlay.style.display = "block"
                }
            }
        }
    });
    /**
     * 设置popou绑定数据
     * @param data popup中的数据
     */
    Popup.prototype.setData = function (data) {
        let txt = "";
        _self.data = data;
        for (let val in data) {
            if (val.toUpperCase() === "SELECTED" || val.toUpperCase() === "GID" || val.toUpperCase() === "X" || val.toUpperCase() === "Y") {
                continue;
            }
            let value = null;
            switch (val) {
                case "x":
                    value = "x";
                    break;
                case "y":
                    value = "y";
                    break;
                case "id":
                    value = "编号";
                    break;
                case "z":
                    value = "海拔";
                    break;
                case "dangju":
                    value = "档距";
                    break;
                case "dianya":
                    value = "电压";
                    break;
                case "yongtu":
                    value = "用途";
                    break;
                case "xinghao":
                    value = "型号";
                    break;
                case "zhonglei":
                    value = "种类";
                    break;
                case "height":
                    value = "高度";
                    break;
                case "fengji":
                    value = "分级";
                    break;
                case "lon":
                    value = "经度";
                    break;
                case "lat":
                    value = "纬度";
                    break;
                case "name":
                    value = "线路名称";
                    break;
                case "danwei":
                    value = "管理单位";
                    break;
                case "start":
                    value = "起始变电站";
                    break;
                case "end":
                    value = "终止变电站";
                    break;
                case "linestart":
                    value = "起始杆塔号";
                    break;
                case "lineend":
                    value = "终止杆塔号";
                    break;
                case "startpoint":
                    value = "起始地址";
                    break;
                case "endpoint":
                    value = "终止地址";
                    break;
            }
            txt += value + ":" + data[val] + "\n";
        }
        _self.contentTxT = txt;
    };
    /**
     * 气泡框显示
     * @param position 气泡框位置
     * @param data 绑定气泡框中的内容
     */
    Popup.prototype.show = function (position, data) {
        _self.setData(data);
        _self.isShow = true;
        if (position) {
            _self.position = position;

        }
    };
    /**
     * 关闭气泡框
     */
    Popup.prototype.close = function () {
        _self.isShow = false;
        _self.position = null;
        _self.overlay.style.display = "none";
    };
}