/**
 * 路径分析
 * @param viewer 场景主视图
 * @param option 路径分析参数
 * @constructor
 */
function RoadAnalysis(viewer, option) {
    let _self = this;
    _self.url = option.url;
    _self.typeName = option.typeName;
    _self.viewer = viewer;
    _self.startPoint = null;
    _self.endPoint = null;
    _self.roadLayer = new Cesium.GeoJsonDataSource('road');
    _self.drawLayer = new Cesium.PrimitiveCollection();
    _self.drawHelper = new DrawGeometryHelper(viewer);
    _self.viewer.dataSources.add(_self.roadLayer);
    _self.viewer.scene.primitives.add(_self.drawLayer);
    _self.drawLayer.add(new Cesium.BillboardCollection());
    _self.drawLayer.add(new Cesium.BillboardCollection());
    /**
     * 设置起点
     * @param name
     */
    RoadAnalysis.prototype.setdrawPoint = function (name) {
        DrawPoint(name);
    };

    /**
     * 分析
     */
    RoadAnalysis.prototype.query = function () {
        if (_self.startPoint && _self.endPoint) {
            let txt = 'x1:' + _self.startPoint[0] + ';y1:' + _self.startPoint[1] + ';x2:' + _self.endPoint[0] + ';y2:' + _self.endPoint[1];
            $.ajax({
                type: 'get',
                url: _self.url,
                data: {
                    'service': 'wfs',
                    'version': '1.0.0',
                    'request': 'GetFeature',
                    'typeName': _self.typeName,//'SouthSmart:dayanta_roadLine',
                    'maxFeatures': '100000',
                    'outputFormat': 'application/json',
                    'viewparams': txt//'y1:34.2206;x1:108.9594;y2:34.2198;x2:108.9587'
                },
                success: function (data) {
                    _self.roadLayer.load(data, {
                        strokeWidth: 1,
                        clampToGround: true,
                        fill: Cesium.Color.fromAlpha(Cesium.Color.AQUA, 1),
                    });
                }
            });
        }else{
            alert("起点终点不能为空！");
        }
    };
    /**
     * 清除分析结果
     */
    RoadAnalysis.prototype.clean = function () {
        _self.startPoint = null;
        _self.endPoint = null;
        _self.drawHelper.stopDrawing();
        _self.drawLayer.get(0).removeAll();
        _self.drawLayer.get(1).removeAll();
        _self.roadLayer.entities.removeAll();
        $("#road-endpoint").val("");
        $("#road-startpoint").val("");
    };

    /**
     * 坐标转换
     * @param cartesian
     * @returns {*[]}
     */
    function cartesian2LonLat(cartesian) {
        var cartographic = Cesium.Cartographic.fromCartesian(cartesian);
        var lon = Cesium.Math.toDegrees(cartographic.longitude);
        var lat = Cesium.Math.toDegrees(cartographic.latitude);
        return [lon, lat];
    }

    /**
     * 绘制点
     * @param name
     * @constructor
     */
    function DrawPoint(name) {
        let img = '', billboards = null, point = null, id = null, isStart = null;
        switch (name) {
            case 'road-spoint':
                isStart = true;
                id = $("#road-startpoint");
                billboards = _self.drawLayer.get(0);
                img = "data:image/svg+xml,<svg t=\"1537323945478\" class=\"icon\" style=\"\" viewBox=\"0 0 1024 1024\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" p-id=\"1087\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" width=\"1024\" height=\"1024\"><defs><style type=\"text/css\"></style></defs><path d=\"M642.662387 136.799666c-41.346687-24.686239-87.878466-34.570353-134.440945-34.570353-46.561455 0-93.093235 14.802124-134.439922 34.570353-118.919437 69.140707-155.082054 212.231659-87.877443 325.764412L508.221442 837.732689l222.319411-375.168612C797.745465 349.031325 761.520425 205.940372 642.662387 136.799666zM515.71716 229.455949c10.806113 1.671059 19.11229 2.49789 24.982998 2.49789l56.213279 0c9.118682 0 19.549242-0.827855 31.229259-2.49789-2.49789 11.663644-3.372817 20.407796-2.49789 26.232454l0 61.208037c0 7.494695 0.811482 17.08205 2.49789 28.730345l-28.730345 0c0.811482-5.823636 1.249457-9.993608 1.249457-12.491499l-49.967018 0 0 67.454298c-0.873903 6.667863 2.873444 10.41521 11.242042 11.242042 17.488303 1.671059 32.041764 0.843204 43.721781-2.49789 9.118682-3.325745 13.740956-15.395642 13.740956-36.225039 9.118682 9.993608 18.73776 16.238846 28.730345 18.73776-4.996804 20.829398-11.242042 33.727149-18.73776 38.723953-4.996804 2.49789-17.926278 4.590552-38.723953 6.246261-17.489326 0.843204-30.854728 0.421602-39.97341-1.249457-17.488303-3.325745-25.857924-11.242042-24.982998-23.733541l0-84.942601c-0.873903-4.996804-1.685385-11.242042-2.49789-18.73776 9.993608 1.671059 17.862833 2.49789 23.733541 2.49789l53.714366 0 0-56.212256-53.714366 0c-16.675798 0-27.106358 0.421602-31.229259 1.249457L515.718183 229.455949zM641.882628 490.530013c-63.333444 0-108.302635-1.671059-134.909619-4.996804-27.480888-2.49789-47.093575-7.916297-58.710147-16.238846-21.672602-15.818267-35.413558-30.807656-41.221844-44.970214-5.870708 27.481911-14.177907 52.043307-24.982998 73.700559-6.683213-8.337899-14.989389-15.412015-24.982998-21.23565 20.798698-22.485107 32.04074-62.036915 33.727149-118.66975 22.485107 1.671059 33.727149 4.168949 33.727149 7.494695 0 0.843204-0.436952 1.671059-1.249457 2.49789-4.184299 6.667863-7.494695 16.238846-9.993608 28.730345 7.494695 12.491499 14.989389 23.328311 22.485107 32.477692l0-91.187839L413.286256 338.13209c-14.989389 0-29.605272 0.843204-43.720757 2.49789l0-27.480888c11.617595 0.843204 26.232454 1.671059 43.720757 2.49789l21.23565 0 0-38.723953c-23.359011 0-42.4713 0.843204-57.46069 2.49789l0-26.232454c15.801894 0.843204 34.976606 1.249457 57.46069 1.249457 0.811482-22.485107-0.436952-38.302351-3.747347-47.468105 23.296589 1.671059 34.538631 3.747347 33.727149 6.246261 0 0.843204-0.436952 2.49789-1.249457 4.996804-2.49789 4.168949-3.747347 8.337899-3.747347 12.491499l0 22.485107c22.485107 0 37.849026-0.406253 46.218648-1.249457l0 27.480888c-12.491499-1.655709-27.918863-2.49789-46.218648-2.49789l0 38.723953 11.242042 0c10.80509 0 24.546046-0.827855 41.221844-2.49789l0 27.480888c-14.176884-1.655709-27.91784-2.49789-41.221844-2.49789l-9.993608 0 0 37.474496 9.993608 0c21.61018 0 35.789111-0.405229 42.4713-1.249457l0 28.730345c-14.176884-1.654686-28.355815-2.49789-42.4713-2.49789l-9.993608 0 0 47.468105c31.603789 15.832594 97.80863 18.73776 198.61657 8.744151C648.502395 467.623303 642.694109 478.865345 641.882628 490.530013z\" fill='red'></path></svg>"
                break;
            case 'road-epoint':
                isStart = false;
                id = $("#road-endpoint");
                billboards = _self.drawLayer.get(1);
                img = "data:image/svg+xml,<svg t=\"1537323945478\" class=\"icon\" style=\"\" viewBox=\"0 0 1024 1024\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" p-id=\"1087\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" width=\"1024\" height=\"1024\"><defs><style type=\"text/css\"></style></defs><path d=\"M552.321846 285.001009c6.302543 18.23941 15.043624 32.509415 26.161846 42.811038 8.680706-7.92346 18.611893-22.594601 29.730115-44.00012C596.321966 284.615223 577.651744 285.001009 552.321846 285.001009z\" p-id=\"1494\"></path><path d=\"M652.957871 152.792918c-39.392172-23.50125-83.689051-32.910551-127.986953-32.910551-44.296879 0-88.623433 14.09195-127.98593 32.910551-113.211435 65.822125-147.668201 202.043622-83.659375 310.126246l211.646328 357.158423 211.646328-357.158423C800.595372 354.836541 766.10893 218.615043 652.957871 152.792918zM400.106072 337.325725l-3.567245 1.189082-8.324596-24.972764 2.378164-2.378164c26.935466-25.359574 44.357254-54.30072 52.324716-86.811158 19.027355 6.347568 29.730115 11.104919 32.108279 14.270005 0 0.803295-0.831948 1.992377-2.378164 3.567245-3.983731 1.591241-7.135514 4.370541-9.513678 8.324596-1.605567 1.591241-3.567245 4.370541-5.946432 8.324596-21.405519 30.131251-35.675524 47.968501-42.811038 53.513798l41.621956-1.189082c7.135514-10.301623 14.270005-25.359574 21.405519-45.189202 15.816221 7.937786 24.972764 14.671141 27.350928 20.216437 0 0.803295-1.189082 1.992377-3.567245 3.567245-3.211135 1.590218-5.588275 3.567245-7.134491 5.946432-1.605567 1.590218-5.172813 6.347568-10.70276 14.270005-27.767414 38.856983-47.567365 64.216557-59.459207 76.108399 26.935466-4.756327 48.756447-9.112542 65.405639-13.080923l-1.189082 24.972764c-36.508495 4.756327-64.633043 9.513678-84.432994 14.270005l-4.756327 1.189082-11.891841-27.351951 2.378164-1.189082c13.438057-3.954055 31.275307-22.193465 53.513798-54.702879C424.662351 331.781452 410.392346 334.159616 400.106072 337.325725zM400.106072 472.894354l-9.513678-26.161846 104.649432-20.216437 2.378164 23.783683L400.106072 472.894354zM608.213807 501.434364c-19.859303-18.23941-51.551096-35.274388-95.135754-51.135634l16.649192-22.594601c36.449143 15.861246 69.330018 32.509415 98.702999 49.946552L608.213807 501.434364zM615.349321 445.542402c-24.616654-17.437138-49.589418-29.730115-74.919317-36.864606l14.270005-21.405519c15.043624 6.347568 39.599903 17.838274 73.730235 34.486442L615.349321 445.542402zM648.646682 397.975037c-30.919197-11.891841-54.345746-24.972764-70.161966-39.243793-20.6319 15.861246-44.833091 29.730115-72.541153 41.621956-3.983731-9.513678-9.156544-17.437138-15.459087-23.783683 28.54001-7.92346 52.323693-19.413142 71.351048-34.486442-11.118222-13.467733-18.670222-26.161846-22.594601-38.054711-10.345626 17.451464-19.859303 31.722492-28.541033 42.811038-4.756327-6.332219-12.307304-10.70276-22.594601-13.080923 24.557302-26.949792 45.189202-64.602344 61.83737-112.973004 11.059893 2.378164 22.179139 6.748704 33.29736 13.080923 0 0.803295-0.831948 1.992377-2.378164 3.567245-6.361895 5.559623-12.724813 14.672164-19.027355 27.351951 43.584658-0.787946 72.124667-1.977028 85.622076-3.567245-11.118222 26.161846-28.956495 53.513798-53.513798 82.054831 17.421788 13.482059 41.978067 22.208814 73.730235 26.161846C660.538523 375.781572 654.176628 385.29525 648.646682 397.975037z\" fill='red'></path></svg>"
                break;
        }
        billboards.removeAll();
        _self.roadLayer.entities.removeAll();
        _self.drawHelper.startDrawingMarker({
            callback: function (position) {
                billboards.add({
                    show: true,
                    position: position,
                    pixelOffset: new Cesium.Cartesian2(0, 0),
                    eyeOffset: new Cesium.Cartesian3(0.0, 0.0, -30.0),
                    horizontalOrigin: Cesium.HorizontalOrigin.CENTER,
                    verticalOrigin: Cesium.VerticalOrigin.BOTTOM,
                    width: 10,
                    height: 10,
                    image: img,//"data:image/svg+xml,<svg t=\"1537323945478\" class=\"icon\" style=\"\" viewBox=\"0 0 1024 1024\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" p-id=\"1087\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" width=\"1024\" height=\"1024\"><defs><style type=\"text/css\"></style></defs><path d=\"M552.321846 285.001009c6.302543 18.23941 15.043624 32.509415 26.161846 42.811038 8.680706-7.92346 18.611893-22.594601 29.730115-44.00012C596.321966 284.615223 577.651744 285.001009 552.321846 285.001009z\" p-id=\"1494\"></path><path d=\"M652.957871 152.792918c-39.392172-23.50125-83.689051-32.910551-127.986953-32.910551-44.296879 0-88.623433 14.09195-127.98593 32.910551-113.211435 65.822125-147.668201 202.043622-83.659375 310.126246l211.646328 357.158423 211.646328-357.158423C800.595372 354.836541 766.10893 218.615043 652.957871 152.792918zM400.106072 337.325725l-3.567245 1.189082-8.324596-24.972764 2.378164-2.378164c26.935466-25.359574 44.357254-54.30072 52.324716-86.811158 19.027355 6.347568 29.730115 11.104919 32.108279 14.270005 0 0.803295-0.831948 1.992377-2.378164 3.567245-3.983731 1.591241-7.135514 4.370541-9.513678 8.324596-1.605567 1.591241-3.567245 4.370541-5.946432 8.324596-21.405519 30.131251-35.675524 47.968501-42.811038 53.513798l41.621956-1.189082c7.135514-10.301623 14.270005-25.359574 21.405519-45.189202 15.816221 7.937786 24.972764 14.671141 27.350928 20.216437 0 0.803295-1.189082 1.992377-3.567245 3.567245-3.211135 1.590218-5.588275 3.567245-7.134491 5.946432-1.605567 1.590218-5.172813 6.347568-10.70276 14.270005-27.767414 38.856983-47.567365 64.216557-59.459207 76.108399 26.935466-4.756327 48.756447-9.112542 65.405639-13.080923l-1.189082 24.972764c-36.508495 4.756327-64.633043 9.513678-84.432994 14.270005l-4.756327 1.189082-11.891841-27.351951 2.378164-1.189082c13.438057-3.954055 31.275307-22.193465 53.513798-54.702879C424.662351 331.781452 410.392346 334.159616 400.106072 337.325725zM400.106072 472.894354l-9.513678-26.161846 104.649432-20.216437 2.378164 23.783683L400.106072 472.894354zM608.213807 501.434364c-19.859303-18.23941-51.551096-35.274388-95.135754-51.135634l16.649192-22.594601c36.449143 15.861246 69.330018 32.509415 98.702999 49.946552L608.213807 501.434364zM615.349321 445.542402c-24.616654-17.437138-49.589418-29.730115-74.919317-36.864606l14.270005-21.405519c15.043624 6.347568 39.599903 17.838274 73.730235 34.486442L615.349321 445.542402zM648.646682 397.975037c-30.919197-11.891841-54.345746-24.972764-70.161966-39.243793-20.6319 15.861246-44.833091 29.730115-72.541153 41.621956-3.983731-9.513678-9.156544-17.437138-15.459087-23.783683 28.54001-7.92346 52.323693-19.413142 71.351048-34.486442-11.118222-13.467733-18.670222-26.161846-22.594601-38.054711-10.345626 17.451464-19.859303 31.722492-28.541033 42.811038-4.756327-6.332219-12.307304-10.70276-22.594601-13.080923 24.557302-26.949792 45.189202-64.602344 61.83737-112.973004 11.059893 2.378164 22.179139 6.748704 33.29736 13.080923 0 0.803295-0.831948 1.992377-2.378164 3.567245-6.361895 5.559623-12.724813 14.672164-19.027355 27.351951 43.584658-0.787946 72.124667-1.977028 85.622076-3.567245-11.118222 26.161846-28.956495 53.513798-53.513798 82.054831 17.421788 13.482059 41.978067 22.208814 73.730235 26.161846C660.538523 375.781572 654.176628 385.29525 648.646682 397.975037z\" fill='red'></path></svg>",//'./Build/Cesium/ThirdParty/Draw/img/glyphicons_242_google_maps.png',
                    color: new Cesium.Color(1.0, 1.0, 1.0, 1.0),
                    sizeInMeters: true
                });
                _self.drawLayer.add(billboards);
                let p = cartesian2LonLat(position);
                point = p;
                (isStart) ? _self.startPoint = p : _self.endPoint = p;
                id.val(p[0].toFixed(4) + ";" + p[1].toFixed(4));
                closeCSS(name);
            }
        })
    }

    /**
     * 关闭css
     * @param name
     */
    function closeCSS(name) {
        $(('#' + name + "-svg")).css('fill', '#ffffff');
        $('.road').removeClass('road');
    }
}