/**
 * 程序主界面css控制主要js文件
 */
$(document).ready(function () {
    /**
     * 点击左边菜单事件
     */
    $('.btnA').click(function () {
        var id = $('.active.btnA').attr("id");
        if (id !== $(this).attr("id") && id) {
            ChangeFunction(id);
        }
        setBtnSelected($(this));
        switch ($(this).attr("id")) {
            case "measures":
                setAnalysisStyle('map-measure');
                analysisClearance();
                break;
            case "show-build-info":
                showBuildInfo();
                break;
            case "analysis-buffer":
                setAnalysisStyle('buffer-analysis');
                analysisBuffer(parseInt($('#buffer-radius').val().trim()));
                break;
            case "analysis-road":
                setAnalysisStyle('road-analysis');
                analysisRoad();
                break;
            case "analysis-height":
                setAnalysisStyle('height-analysis');
                analysisHeight(parseInt($('#height-build').val().trim()));
                break;
            case "analysis-profile":
                setAnalysisStyle('profile-analysis');
                analysisProfile();
                break;
            case "analysis-sight":
                setAnalysisStyle('sight-analysis');
                analysisSight();
                break;
            case "analysis-flood":
                setAnalysisStyle('flood-analysis');
                analysisFlood(parseInt($('#flood-speed').val().trim()));
                break;
            case "analysis-roam":
                setAnalysisStyle('roam-analysis');
                analysisRoam();
                break;
            case "editor":
                // setAnalysisStyle('editInfoBar');
                $('#editInfoBar').hide();
                $('#editLineBar').hide();
                $('#photographyIcon').addClass('visiable');
                EditBuildInfo();
                break;
            case "manager-poi":
                setAnalysisStyle('poi-manager');
                POIManager();
                break;
            case "query":
                setAnalysisStyle('showQueryBar');
                // POIManager();
                showPOI();
                break;
        }
    });

    /**
     * 地图图层管理面板点击事件
     */
    $('.layerManagerSingleLayer').click(function () {
        var id = $(this).attr("id");
        // var oid = $('.visiable').attr("id").substring(0, $('.visiable').attr("id").indexOf('Icon'));
        // console.log(id, oid);
        // if (id === oid) {
        //     return;
        // }
        // $('.visiable').removeClass('visiable');
        // $('#' + id + 'Icon').addClass('visiable');
        // layerManager(id, true);
        if ($('#' + id + 'Icon').hasClass('visiable')) {
            layerManager(id, false);
            $('#' + id + 'Icon').removeClass('visiable');
        } else {
            layerManager(id, true);
            $('#' + id + 'Icon').addClass('visiable');

        }
    });


    /**
     * 场景下方辅助功能按钮点击事件
     */
    $('.over-function').click(function () {
        var id = $(this).attr("id");
        var idd = $('.active.btnA').attr("id");
        if (idd !== $(this).attr("id") && idd) {
            ChangeFunction(idd);
        }
        var bid = $('.active.over-function').attr("id");
        if (bid) {
            switch (bid) {
                case "linkage":
                    var cid = $('.btnA.active').attr("id");
                    if (cid) {
                        ChangeFunction(cid);
                    }
                    endLinkageMap();
                    break;
                case "hawkEye":
                    endHawkEyeMap();
                    break;
                case "layerManager":
                    $('#layerManagerPanal').hide();
                    break;
            }
            $('.active.over-function').removeClass('active');
            $(('#' + bid + "-svg")).css('fill', '#ffffff');
            if (id === bid) {
                return;
            }
        }
        switch (id) {
            case "linkage":
                startLinkageMap();
                break;
            case "hawkEye":
                startHawkEyeMap();
                break;
            case "layerManager":
                $('#layerManagerPanal').show();
                break;
        }
        $(this).addClass('active');
        $(('#' + id + "-svg")).css('fill', '#e7943a');
    });

    /**
     * 点击属性编辑面板按钮
     */
    $('.edit-save-btn').click(function () {
        var id = $(this).attr("id");
        console.log(id);
        switch (id) {
            case "saveEditInfo":
                // let id, x, y, z, dangju, dianya, yongtu, xinghao, zhonglei, height, fengji, lon, lat;
                let id = parseFloat($('#eidt-value-id').val()), x = parseFloat($('#eidt-value-x').val()),
                    y = parseFloat($('#eidt-value-y').val()),
                    z = parseFloat($('#eidt-value-z').val()),
                    dangju = parseFloat($('#eidt-value-dangju').val()),
                    dianya = parseInt($('#eidt-value-dianya').val()),
                    yongtu = $('#eidt-value-yongtu').val(), xinghao = $('#eidt-value-xinghao').val(),
                    zhonglei = $('#eidt-value-zhonglei').val(), height = parseFloat($('#eidt-value-height').val()),
                    fengji = $('#eidt-value-fengji').val(), lon = parseFloat($('#eidt-value-lon').val()),
                    lat = parseFloat($('#eidt-value-lat').val());
                updateBuild(id, x, y, z, dangju, dianya, yongtu, xinghao, zhonglei, height, fengji, lon, lat);
                break;
            case "saveEditLine":
                let gid = $('#eidt-value-gid').val(), dianyadengji = $('#eidt-value-dianyadengji').val(),
                    danwei = $('#eidt-value-danwei').val(), start = $('#eidt-value-start').val(),
                    end = $('#eidt-value-end').val(), linestart = $('#eidt-value-linestart').val(),
                    lineend = $('#eidt-value-lineend').val(), startpoint = $('#eidt-value-startpoint').val(),
                    endpoint = $('#eidt-value-endpoint').val();
                updateLine(gid, dianyadengji, danwei, start, end, linestart, lineend, startpoint, endpoint);
                break;
            case "closeEditInfo":
                $('#editInfoBar').hide();
                break;
            case "closeEditLine":
                $('#editLineBar').hide();
                break;
            case "saveEditPOI":
                if ($('#eidt-POI-name').val().trim()) {
                    addPOI($('#eidt-POI-name').val().trim(), $('#eidt-POI-miaoshu').val().trim());
                    $('#editPOIBar').hide();
                } else {
                    alert("请输入标注名称！");
                }
                break;
            case "closeEditPOI":
                $('#eidt-POI-name').val("");
                $('#eidt-POI-miaoshu').val("");
                $('#editPOIBar').hide();
                break;
        }
    });

    /**
     * 点击测量工具条事件
     */
    $('.measure-button').click(function () {
        var id = $(this).attr("id");
        var bid = $('.measure').attr("id");
        if (bid) {
            if (id === bid) {
                return;
            }
            $('.measure').removeClass('measure');
            $(('#' + bid + "-svg")).css('fill', '#ffffff');
        }
        switch (id) {
            case "measure-clean":
                cleanClearance();
                break;
            default:
                startClearance();
                $(this).addClass('measure');
                $(('#' + id + "-svg")).css('fill', '#e7943a');
                break;
        }
    });

    /**
     * 点击缓冲区工具条事件
     */
    $('.buffer-button').click(function () {
        var id = $(this).attr("id");
        var bid = $('.buffer').attr("id");
        if (bid) {
            if (id === bid) {
                return;
            }
            $('.buffer').removeClass('buffer');
            $(('#' + bid + "-svg")).css('fill', '#ffffff');
        }
        switch (id) {
            case "buffer-clean":
                CleanBuffer();
                break;
            default:
                StartBuffer(id);
                $(this).addClass('buffer');
                $(('#' + id + "-svg")).css('fill', '#e7943a');
                break;
        }
    });

    /**
     * 点击路径分析工具条事件
     */
    $('.road-button').click(function () {
        var id = $(this).attr("id");
        var bid = $('.road').attr("id");
        if (bid) {
            if (id === bid) {
                return;
            }
            $('.road').removeClass('road');
            $(('#' + bid + "-svg")).css('fill', '#ffffff');
        }
        switch (id) {
            case "road-query":
                RoadQuery();
                break;
            case "road-clean":
                CleanRoad();
                break;
            default:
                setPoint(id);
                $(this).addClass('road');
                $(('#' + id + "-svg")).css('fill', '#e7943a');
                break;
        }
    });

    /**
     * 点击控高分析工具条事件
     */
    $('.height-button').click(function () {
        var id = $(this).attr("id");
        var bid = $('.height').attr("id");
        if (bid) {
            if (id === bid) {
                return;
            }
            $('.height').removeClass('height');
            $(('#' + bid + "-svg")).css('fill', '#ffffff');
        }
        switch (id) {
            case "height-polygon":
                $(this).addClass('height');
                $(('#' + id + "-svg")).css('fill', '#e7943a');
                drawHeightGeometry('height-polygon');
                break;
            case "height-clean":
                CleanHeight();
                break;
        }
    });

    /**
     * 点击剖面分析工具条事件
     */
    $('.profile-button').click(function () {
        var id = $(this).attr("id");
        var bid = $('.profile').attr("id");
        if (bid) {
            if (id === bid) {
                return;
            }
            $('.profile').removeClass('profile');
            $(('#' + bid + "-svg")).css('fill', '#ffffff');
        }
        switch (id) {
            case "profile-polyline":
                $(this).addClass('profile');
                $(('#' + id + "-svg")).css('fill', '#e7943a');
                StartProfile('profile-polyline');
                break;
            case "profile-clean":
                CleanProfile();
                break;
        }
    });

    /**
     * 点击通视分析工具条事件
     */
    $('.sight-button').click(function () {
        var id = $(this).attr("id");
        var bid = $('.sight').attr("id");
        if (bid) {
            if (id === bid) {
                return;
            }
            $('.sight').removeClass('sight');
            $(('#' + bid + "-svg")).css('fill', '#ffffff');
        }
        switch (id) {
            case "sight-polyline":
                $(this).addClass('sight');
                $(('#' + id + "-svg")).css('fill', '#e7943a');
                StartSight('sight-polyline');
                break;
            case "sight-clean":
                CleanSight();
                break;
        }
    });

    /**
     * 点击水淹分析工具条事件
     */
    $('.flood-button').click(function () {
        var id = $(this).attr("id");
        var bid = $('.flood').attr("id");
        if (bid) {
            if (id === bid) {
                return;
            }
            $('.flood').removeClass('flood');
            $(('#' + bid + "-svg")).css('fill', '#ffffff');
        }
        switch (id) {
            case "flood-start":
                if ($(this).hasClass('active')) {
                    $(this).addClass('flood');
                    $(('#' + id + "-svg")).css('fill', '#e7943a');
                    StartFlood(id);
                }
                break;
            case "flood-pause":
                if ($(this).hasClass('active')) {
                    $(this).addClass('flood');
                    $(('#' + id + "-svg")).css('fill', '#e7943a');
                    PauseFlood();
                }
                break;
            case "flood-stop":
                if ($(this).hasClass('active')) {
                    StopFlood(id);
                }
                break;
            case "flood-polygon":
                $(this).addClass('flood');
                drawFloodPolygon(id);
                $(('#' + id + "-svg")).css('fill', '#e7943a');
                break;
            case "flood-clean":
                CleanFlood();
                break;
        }
    });

    /**
     * 点击飞行工具条事件
     */
    $('.roam-button').click(function () {
        var id = $(this).attr("id");
        var bid = $('.roam').attr("id");
        if (bid) {
            if (id === bid) {
                return;
            }
            $('.roam').removeClass('roam');
            $(('#' + bid + "-svg")).css('fill', '#ffffff');
        }
        switch (id) {
            case "roam-default":
                LoadDefaultRoamRoad();
                break;
            case "roam-polyline":
                $(this).addClass('roam');
                $(('#' + id + "-svg")).css('fill', '#e7943a');
                DrawRoamRoad(id);
                break;
            case "roam-start":
                if ($(this).hasClass('active')) {
                    $(this).addClass('roam');
                    $(('#' + id + "-svg")).css('fill', '#e7943a');
                    StartRoam(id);
                }
                break;
            case "roam-pause":
                if ($(this).hasClass('active')) {
                    $(this).addClass('roam');
                    $(('#' + id + "-svg")).css('fill', '#e7943a');
                    PauseRoam();
                }
                break;
            case "roam-stop":
                if ($(this).hasClass('active')) {
                    StopRoam(id);
                }
                break;
            case "roam-clean":
                CleanRoam();
                break;
        }
    });

    /**
     * 点击POI管理工具条事件
     */
    $('.poi-button').click(function () {
        var id = $(this).attr("id");
        var bid = $('.poi').attr("id");
        if (bid) {
            if (bid === "get-poi") {
                closePOIBar();
                $('.poi').removeClass('poi');
                $(('#' + bid + "-svg")).css('fill', '#ffffff');
                return;
            } else if (id === bid) {
                return;
            }
            $('.poi').removeClass('poi');
            $(('#' + bid + "-svg")).css('fill', '#ffffff');
        }
        switch (id) {
            case "draw-poi":
                $(this).addClass('poi');
                $(('#' + id + "-svg")).css('fill', '#e7943a');
                drawPOI(id);
                break;
            case "get-poi":
                $(this).addClass('poi');
                $(('#' + id + "-svg")).css('fill', '#e7943a');
                getPOI();
                break;
            case "clean-poi":
                CleanPOIManager();
                break;
        }
    });

    /**
     * 查看标绘面板点击li事件
     */
    $(".poi_collection").on("click", "div", function () {
        let id = $(this).attr("id");
        switch (id) {
            case "poi_item_img":
                zoomToPOI($(this).parent().attr("id"));
                break;
            case "poi_item_txt":
                zoomToPOI($(this).parent().attr("id"));
                break;
            case "poi_item_btn":
                deletePOI($(this).parent().attr("id"));
                break;
        }
    });

    $(".pois_collection").on("click", "div", function () {
        let id = $(this).attr("id");
        switch (id) {
            case "poi_item_img":
                zoomToPOIs($(this).parent().attr("id"));
                break;
            case "poi_item_txt":
                zoomToPOIs($(this).parent().attr("id"));
        }
    })

    /**
     * 缓冲区分析缓冲半径文本框改变事件
     */
    $("#buffer-radius").bind('input propertychange', function () {
        var radius = parseInt($('#buffer-radius').val().trim().replace(/\D/gi, ""));
        if (radius) {
            setBufferRadius(radius);
        } else {
            alert("缓冲半径值不能为空！")
        }
    });

    /**
     * 控高分析高度文本框改变事件
     */
    $("#height-build").bind('input propertychange', function () {
        var height = parseInt($('#height-build').val().trim().replace(/\D/gi, ""));
        if (height) {
            setHeight(height);
        } else {
            alert("高度值不能为空！")
        }
    });

    /**
     * 水淹分析水淹速度文本框改变事件
     */
    $("#flood-speed").bind('input propertychange', function () {
        var height = parseInt($('#flood-speed').val().trim().replace(/\D/gi, ""));
        if (height) {
            setFloodSpeed(height);
        } else {
            alert("速度值不能为空！")
        }
    });


    /**
     * 点击菜单样式
     * @param btn 点击的按钮
     */
    function setBtnSelected(btn) {
        btn.hasClass('active') ? btn.removeClass('active') : btn.addClass('active');
    }

    /**
     * 设置菜单样式样式
     */
    function setAnalysisStyle(id) {
        $('#' + id).is(':visible') ? $('#' + id).css("display", "none") : $('#' + id).css("display", "block");
    }

    /**
     * 关闭当前开启的功能
     * @param name 当前开启功能名称
     * @constructor
     */
    function ChangeFunction(name) {
        setBtnSelected($('#' + name));
        switch (name) {
            case "measures":
                analysisClearance();
                setAnalysisStyle('map-measure');
                closeFunction('measure');
                break;
            case "show-build-info":
                showBuildInfo();
                break;
            case "analysis-buffer":
                setAnalysisStyle('buffer-analysis');
                analysisBuffer(parseInt($('#buffer-radius').val().trim()));
                closeFunction('buffer');
                break;
            case "analysis-road":
                setAnalysisStyle('road-analysis');
                analysisRoad();
                closeFunction('road');
                break;
            case "analysis-height":
                setAnalysisStyle('height-analysis');
                analysisHeight(parseInt($('#height-build').val().trim()));
                closeFunction('height');
                break;
            case "analysis-profile":
                setAnalysisStyle('profile-analysis');
                analysisProfile();
                closeFunction('profile');
                break;
            case "analysis-sight":
                setAnalysisStyle('sight-analysis');
                analysisSight();
                closeFunction('sight');
                break;
            case "analysis-flood":
                setAnalysisStyle('flood-analysis');
                analysisFlood(parseInt($('#flood-speed').val().trim()));
                closeFunction('flood');
                break;
            case "analysis-roam":
                setAnalysisStyle('roam-analysis');
                analysisRoam();
                closeFunction('roam');
                break;
            case "editor":
                // setAnalysisStyle('editInfoBar');
                $('#photographyIcon').addClass('visiable');
                EditBuildInfo();
                $('#editLineBar').hide();
                $('#editInfoBar').hide();
                break;
            case "manager-poi":
                setAnalysisStyle('poi-manager');
                POIManager();
                closeFunction('poi');
                break;
            case "query":
                setAnalysisStyle('showQueryBar');
                // POIManager();
                showPOI();
                break;
        }
    }

    /**
     * 关闭当前开启的功能
     * @param id 该功能对应菜单名称
     */
    function closeFunction(id) {
        var bid = $('.' + id).attr("id");
        if (bid) {
            $('.' + id).removeClass(id);
            $(('#' + bid + "-svg")).css('fill', '#ffffff');
        }
    }
})
;