/**
 * 程序功能主要js文件
 */

/** 场景配置，矢量白模，倾斜摄影模型，场景事件hander */
let config = null, vector = null, photography = null, pointClouds = [], handler = null, pois = [], poi = null;
let icon = '<svg viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" width="28" height="28"><defs><style type="text/css"></style></defs><path id="measure-polyline-svg" d="M569.426921 276.616038c-49.018414 49.052183-49.018414 128.888486 0 177.975461 24.020066 23.952528 55.799864 36.873816 88.759533 36.873816 9.513678 0 19.094894-1.079588 28.64234-3.272533 22.940478-5.296633 43.890626-16.935718 60.58996-33.635051l0.033769-0.033769c17.070794-17.104563 28.777417-38.526455 33.905204-62.007239 9.209756-42.119283-3.475148-85.470627-33.938973-115.917056C698.366571 227.54646 618.479103 227.496317 569.426921 276.616038zM713.88501 377.773949c-2.328022 10.525728-7.624654 20.208251-15.349593 27.966958-7.523347 7.523347-16.935718 12.752442-27.225061 15.114233-19.397792 4.520967-39.10053-1.248434-53.032844-15.146978-22.097274-22.131043-22.097274-58.127885 0-80.241532 11.06501-11.06501 25.606191-16.598027 40.146349-16.598027s29.080316 5.51562 40.146349 16.581654C712.299909 339.196329 718.034517 358.762967 713.88501 377.773949z M956.212104 424.970878l-17.475-234.651274c-4.149507-56.289004-49.761334-101.798501-106.066711-105.8467L598.777389 67.653843c-42.339294-3.036149-84.441181 12.532431-114.668623 42.777269L110.447485 484.07602c-57.418734 57.418734-57.418734 150.868079 0 208.286814l221.208101 221.208101c27.798113 27.831882 64.807005 43.148729 104.143918 43.148729 39.33589 0 76.344782-15.315824 104.143918-43.148729L913.468604 540.04473C943.797353 509.715981 959.38333 467.748147 956.212104 424.970878zM864.618013 491.194138 491.091808 864.721367c-30.497595 30.497595-80.090083 30.497595-110.586654 0l-221.208101-221.208101c-30.497595-30.497595-30.497595-80.090083 0-110.586654l373.695051-373.661282c14.675234-14.709003 34.545794-22.890336 55.225789-22.890336 1.855254 0 3.744277 0.067538 5.634324 0.202615l233.859235 16.817014c22.367427 1.602498 40.483017 19.667945 42.136679 42.035372L887.323131 430.098665C889.00954 452.80276 880.744295 475.068879 864.618013 491.194138z" fill="#ffffff"></path></svg>';
/**场景功能开关*/
let isAnalysisMeasure = false, isBuildInfoShow = false, isAnalysisRoam = false, isEditBuildInfo = false,
    isShowPOI = false, isAnalysisClearance = false;
/** click选中要素*/
let selectedFeature = {
    feature: undefined,
    originalColor: Cesium.Color.RED.withAlpha(0.01)
};
/** move选中要素 */
let highlightedFeature = {
    feature: undefined,
    originalColor: Cesium.Color.RED.withAlpha(0.01)
};
/** 获取场景配置参数 */
$.getJSON("Build/Static/js/config.json", "", function (data) {
    config = data;
    $(document).ready(function () {
        initialize();
    });
});

/**
 * 系统初始化
 */
function initialize() {
    let ESRIImg = new Cesium.ArcGisMapServerImageryProvider({
        name: config.ESRIImg.name,
        url: config.ESRIImg.url,
        layer: config.ESRIImg.layer,
        style: config.ESRIImg.style,
        format: config.ESRIImg.format,
        tileMatrixSetID: config.ESRIImg.tileMatrixSetID,
        minimumLevel: config.ESRIImg.minimumLevel,
        maximumLevel: config.ESRIImg.maximumLevel,
        enablePickFeatures: config.ESRIImg.enablePickFeatures,
    });
    let TDTVec = new Cesium.ImageryLayer(new Cesium.WebMapTileServiceImageryProvider({
        name: config.TDTVec.name,
        url: config.TDTVec.url,
        layer: config.TDTVec.layer,
        style: config.TDTVec.style,
        format: config.TDTVec.format,
        tileMatrixSetID: config.TDTVec.tileMatrixSetID,
        minimumLevel: config.TDTVec.minimumLevel,
        maximumLevel: config.TDTVec.maximumLevel,
    }), {
        show: config.TDTVec.show
    });
    viewer = new Cesium.Viewer('mainScene', {
        // requestRenderMode : true,
        sceneMode: Cesium.SceneMode.SCENE3D,
        scene3DOnly: true,
        fullscreenButton: false,
        homeButton: false,
        animation: false,
        baseLayerPicker: false,
        geocoder: false,
        timeline: false,
        sceneModePicker: false,
        navigationHelpButton: false,
        selectionIndicator: false,
        infoBox: false,
        imageryProvider: ESRIImg,
        contextOptions: {
            webgl: {
                alpha: true,
                depth: false,
                stencil: true,
                antialias: true,
                premultipliedAlpha: true,
                preserveDrawingBuffer: true,
                failIfMajorPerformanceCaveat: true
            }
        },
    });
    Cesium.viewerCesiumNavigationMixin(viewer, {
        enableCompass: true,
        enableZoomControls: true,
        enableDistanceLegend: true,
        enableCompassOuterRing: true,
        defaultPositionView: {
            destination: new Cesium.Cartesian3.fromDegrees(config.InitialPosition.lon, config.InitialPosition.lat, config.InitialPosition.height),
            orientation: new Cesium.HeadingPitchRoll.fromDegrees(config.InitialOrientation.heading, config.InitialOrientation.pitch, config.InitialOrientation.roll)
        }
    });
    viewer.terrainProvider = new Cesium.CesiumTerrainProvider({
        url: config.Terrain,
        requestWaterMask: false,
        requestVertexNormals: false
    });
    viewer.scene.moon.show = false;
    viewer.imageryLayers.add(TDTVec);
    viewer.scene.globe.depthTestAgainstTerrain = true;
    viewer.scene.screenSpaceCameraController.enableLook = false;
    viewer.scene.screenSpaceCameraController.enableTranslate = false;
    viewer.cesiumWidget.creditContainer.style.display = "none";
    viewer.scene.globe.baseColor = Cesium.Color.fromCssColorString(config.globe.baseColor);
    viewer.cesiumWidget.screenSpaceEventHandler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_DOUBLE_CLICK);

    vector = add3Dtile(config.MainModelData.vector.url);
    photography = add3Dtile(config.MainModelData.photography.url);
    for (let i = 0; i < config.MainModelData.pointClouds.url.length; i++) {
        pointClouds.push(add3Dtile(config.MainModelData.pointClouds.url[i], true));
    }

    viewer.camera.setView({
        destination: new Cesium.Cartesian3.fromDegrees(config.InitialPosition.lon, config.InitialPosition.lat, config.InitialPosition.height),
        orientation: new Cesium.HeadingPitchRoll.fromDegrees(config.InitialOrientation.heading, config.InitialOrientation.pitch, config.InitialOrientation.roll)
    });
    viewer.popup = new Popup(viewer);
    handler = new Cesium.ScreenSpaceEventHandler(viewer.scene.canvas);
}

/**
 * 添加三维模型
 * @param url 模型url
 * @param isStyle 是否需要自定义渲染
 * @param isShow 是否显示
 * @returns {Cesium3DTile} 3dtile
 */
function add3Dtile(url, isStyle, isShow) {
    let tile = viewer.scene.primitives.add(new Cesium.Cesium3DTileset({
        url: url,
        show: isShow,
        maximumMemoryUsage: 200,
    }));
    tile.readyPromise.then(function (tileset) {
        let x = 0,
            y = 0,
            z = 20;
        let boundingSphere = tileset.boundingSphere;
        let cartographic = Cesium.Cartographic.fromCartesian(boundingSphere.center);
        let surface = Cesium.Cartesian3.fromRadians(cartographic.longitude, cartographic.latitude, 0.0);
        let offset = Cesium.Cartesian3.fromRadians((cartographic.longitude + x), (cartographic.latitude + y), z);
        let translation = Cesium.Cartesian3.subtract(offset, surface, new Cesium.Cartesian3());
        tile.modelMatrix = Cesium.Matrix4.fromTranslation(translation);
    });
    if (isStyle) {
        tile.style = new Cesium.Cesium3DTileStyle({
            color: {
                conditions: config.MainModelData.style
            }
        });
    }
    return tile;
}

/**
 * 模型单体化开关
 */
function showBuildInfo() {
    if (isBuildInfoShow) {
        if (Cesium.defined(selectedFeature.feature)) {
            selectedFeature.feature.color = selectedFeature.originalColor;
            selectedFeature.feature = undefined;
        }
        if (Cesium.defined(highlightedFeature.feature)) {
            highlightedFeature.feature.color = highlightedFeature.originalColor;
            highlightedFeature.feature = undefined;
        }
        viewer.popup.close();
        handler.removeInputAction(Cesium.ScreenSpaceEventType.MOUSE_MOVE);
        handler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_CLICK);
    } else {
        handler.setInputAction(function onMove(movement) {
            var position = viewer.scene.pickPosition(movement.endPosition);
            if (position) {
                if (isBuildInfoShow) {
                    var pickedFeature = viewer.scene.pick(movement.endPosition);
                    if (Cesium.defined(pickedFeature)) {
                        if (selectedFeature.feature === pickedFeature || highlightedFeature.feature === pickedFeature) {
                            return;
                        }
                        if (Cesium.defined(highlightedFeature.feature)) {
                            highlightedFeature.feature.color = highlightedFeature.originalColor;
                            highlightedFeature.feature = undefined;
                        }
                        if (pickedFeature !== selectedFeature.feature) {
                            highlightedFeature.feature = pickedFeature;
                            Cesium.Color.clone(pickedFeature.color, highlightedFeature.originalColor);
                            pickedFeature.color = Cesium.Color.fromAlpha(Cesium.Color.CYAN, 1);
                        }
                    }
                }
            }
        }, Cesium.ScreenSpaceEventType.MOUSE_MOVE);
        handler.setInputAction(function onClick(movement) {
            var position = viewer.scene.pickPosition(movement.position);
            if (position) {
                if (isBuildInfoShow) {
                    if (Cesium.defined(selectedFeature.feature)) {
                        selectedFeature.feature.color = selectedFeature.originalColor;
                        selectedFeature.feature = undefined;
                    }
                    var pickedFeature = viewer.scene.pick(movement.position);
                    if (selectedFeature.feature === pickedFeature) {
                        return;
                    }
                    selectedFeature.feature = pickedFeature;
                    if (pickedFeature === highlightedFeature.feature) {
                        Cesium.Color.clone(highlightedFeature.originalColor, selectedFeature.originalColor);
                        highlightedFeature.feature = undefined;
                    } else {
                        Cesium.Color.clone(pickedFeature.color, selectedFeature.originalColor);
                    }
                    if (pickedFeature instanceof Cesium.Cesium3DTileFeature) {
                        pickedFeature.color = Cesium.Color.fromAlpha(Cesium.Color.TOMATO, 1);

                        if (pickedFeature._batchId < 14) {
                            getBuildInfoById(pickedFeature._batchId, position, true, config.BuildInfo)
                        } else if (pickedFeature._batchId >= 14) {
                            console.log(pickedFeature);
                            getLineInfoById(pickedFeature._batchId, position, true, config.LineInfo)
                        }
                    }

                }
            }
        }, Cesium.ScreenSpaceEventType.LEFT_CLICK);
    }
    // vector.show = !vector.show;
    isBuildInfoShow = !isBuildInfoShow;
}

function analysisClearance() {
    if (isAnalysisClearance) {
        viewer.clearance.startDraw();
        viewer.clearance.clean();
        viewer.clearance = null;
    } else {
        viewer.clearance = new ClearanceAnalysis(viewer);
    }
    isAnalysisClearance = !isAnalysisClearance;
}

function startClearance() {
    viewer.clearance.startDraw();
}

function cleanClearance() {
    viewer.clearance.clean();
}

/**
 * 飞行
 */
function analysisRoam() {
    if (isAnalysisRoam) {
        CleanRoam();
        viewer.roamAnalysis = null;
    } else {
        viewer.roamAnalysis = new RoamAnalysis(viewer);
    }
    isAnalysisRoam = !isAnalysisRoam;
}

/**
 * 开始飞行
 * @param name 开始飞行按钮id
 * @constructor RoamAnalysis()
 */
function StartRoam(name) {
    viewer.roamAnalysis.startRoam(name);
}

/**
 * 暂停飞行
 * @constructor RoamAnalysis()
 */
function PauseRoam() {
    viewer.roamAnalysis.pauseRoam();
}

/**
 * 停止飞行
 * @param name 停止飞行按钮id
 * @constructor RoamAnalysis()
 */
function StopRoam(name) {
    viewer.roamAnalysis.stopRoam(name);
}

/**
 * 加载默认飞行路径
 * @constructor RoamAnalysis()
 */
function LoadDefaultRoamRoad() {
    viewer.roamAnalysis.loadDefaultRoamRoad();
}

/**
 * 自定义飞行路径
 * @param name 绘制飞行路径按钮id
 * @constructor RoamAnalysis()
 */
function DrawRoamRoad(name) {
    viewer.roamAnalysis.drawRoamRoad(name);
}

/**
 * 清除飞行
 * @constructor RoamAnalysis()
 */
function CleanRoam() {
    viewer.roamAnalysis.Clean();
}

/**
 * 二三维联动
 */
function startLinkageMap() {
    if (viewer.hawkEyeMap) {
        endHawkEyeMap()
        viewer.hawkEyeMap = null
    }
    viewer.linkageby2D3D = new Linkageby2D3D(viewer, config.linkageby2D3D);
    viewer.linkageby2D3D.spiltScreen();
}

/**
 * 结束二三维联动
 */
function endLinkageMap() {
    viewer.linkageby2D3D.reset();
    viewer.linkageby2D3D = null;
}


/**
 * 图层管理
 * @param name 图层名称
 * @param show 是否显示
 */
function layerManager(name, show) {
    switch (name) {
        case "vector":
            vector.show = show;
            break;
        case "pointCloud":
            pointClouds[0].show = show;
            pointClouds[1].show = show;
            pointClouds[2].show = show;
            break;
        case "photography":
            photography.show = show;
            break;
    }
}

/**
 * 建筑物属性修改
 * @constructor
 */
function EditBuildInfo() {
    if (isEditBuildInfo) {
        if (Cesium.defined(selectedFeature.feature)) {
            selectedFeature.feature.color = selectedFeature.originalColor;
            selectedFeature.feature = undefined;
        }
        if (Cesium.defined(highlightedFeature.feature)) {
            highlightedFeature.feature.color = highlightedFeature.originalColor;
            highlightedFeature.feature = undefined;
        }
        viewer.popup.close();
        handler.removeInputAction(Cesium.ScreenSpaceEventType.MOUSE_MOVE);
        handler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_CLICK);
        // $('#editInfoBar').hide();
    } else {
        // photography.show = true;
        handler.setInputAction(function onMove(movement) {
            var position = viewer.scene.pickPosition(movement.endPosition);
            if (position) {
                if (isEditBuildInfo) {
                    var pickedFeature = viewer.scene.pick(movement.endPosition);
                    if (Cesium.defined(pickedFeature)) {
                        if (selectedFeature.feature === pickedFeature || highlightedFeature.feature === pickedFeature) {
                            return;
                        }
                        if (Cesium.defined(highlightedFeature.feature)) {
                            highlightedFeature.feature.color = highlightedFeature.originalColor;
                            highlightedFeature.feature = undefined;
                        }
                        if (pickedFeature !== selectedFeature.feature) {
                            highlightedFeature.feature = pickedFeature;
                            Cesium.Color.clone(pickedFeature.color, highlightedFeature.originalColor);
                            pickedFeature.color = Cesium.Color.fromAlpha(Cesium.Color.CYAN, 1);
                        }
                    }
                }
            }
        }, Cesium.ScreenSpaceEventType.MOUSE_MOVE);
        handler.setInputAction(function onClick(movement) {
            var position = viewer.scene.pickPosition(movement.position);
            if (position) {
                if (isEditBuildInfo) {
                    if (Cesium.defined(selectedFeature.feature)) {
                        selectedFeature.feature.color = selectedFeature.originalColor;
                        selectedFeature.feature = undefined;
                    }
                    var pickedFeature = viewer.scene.pick(movement.position);
                    if (selectedFeature.feature === pickedFeature || pickedFeature._batchId === 14) {
                        return;
                    }
                    selectedFeature.feature = pickedFeature;
                    if (pickedFeature === highlightedFeature.feature) {
                        Cesium.Color.clone(highlightedFeature.originalColor, selectedFeature.originalColor);
                        highlightedFeature.feature = undefined;
                    } else {
                        Cesium.Color.clone(pickedFeature.color, selectedFeature.originalColor);
                    }
                    if (pickedFeature instanceof Cesium.Cesium3DTileFeature) {
                        pickedFeature.color = Cesium.Color.fromAlpha(Cesium.Color.BLUEVIOLET, 1);
                        if (pickedFeature._batchId < 14) {
                            getBuildInfoById(pickedFeature._batchId, [], false, config.BuildInfo);
                            $('#editLineBar').hide();
                            $('#editInfoBar').show();
                        }
                        else if (pickedFeature._batchId >= 14) {
                            $('#editInfoBar').hide();
                            $('#editLineBar').show();
                            getLineInfoById(pickedFeature._batchId, position, false, config.LineInfo)
                            console.log(pickedFeature);
                        }
                    }

                }
            }
        }, Cesium.ScreenSpaceEventType.LEFT_CLICK);
    }
    // vector.show = !vector.show;
    isEditBuildInfo = !isEditBuildInfo;
}

/**
 * 更新建筑物信息
 * @param id
 * @param x
 * @param y
 * @param z
 * @param dangju
 * @param dianya
 * @param yongtu
 * @param xinghao
 * @param zhonglei
 * @param height
 * @param fengji
 * @param lon
 * @param lat
 */
function updateBuild(id, x, y, z, dangju, dianya, yongtu, xinghao, zhonglei, height, fengji, lon, lat) {
    updateBuildInfo(id, x, y, z, dangju, dianya, yongtu, xinghao, zhonglei, height, fengji, lon, lat, config.EditInfo)
}

function updateLine(gid, dianyadengji, danwei, start, end, linestart, lineend, startpoint, endpoint) {
    updateLineInfo(gid, dianyadengji, danwei, start, end, linestart, lineend, startpoint, endpoint, config.EditLine)
}

/**
 * 添加POI
 * @param name
 * @param miaoshu
 */
function addPOI(name, miaoshu) {
    viewer.POIManager.addPOI(name, miaoshu, config.addPOI);
}

/**
 * 快速定位到poi点
 * @param index 点所在的索引位置
 */
function zoomToPOI(index) {
    viewer.POIManager.zoomToPOI(index);
}

function zoomToPOIs(index) {
    // viewer.POIManager.zoomToPOI(index);
    console.log(index);
    zoomTo(index);
}

function zoomTo(index) {
    if (poi) {
        if (viewer.entities.contains(poi)) {
            viewer.entities.remove(poi);
            poi = null;
        }
    }
    poi = viewer.entities.add({
        id: "test",
        position: new Cesium.Cartesian3.fromDegrees(pois[index].lon, pois[index].lat),
        billboard: {
            pixelOffset: new Cesium.Cartesian2(0, 0),
            eyeOffset: new Cesium.Cartesian3(0.0, 0.0, -30.0),
            horizontalOrigin: Cesium.HorizontalOrigin.CENTER,
            verticalOrigin: Cesium.VerticalOrigin.BOTTOM,
            width: 30,
            height: 30,
            image: "data:image/svg+xml,<svg t=\"1537323945478\" class=\"icon\" style=\"\" viewBox=\"0 0 1024 1024\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" p-id=\"1087\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" width=\"1024\" height=\"1024\"><defs><style type=\"text/css\"></style></defs><path d=\"M512 599.9c-90.4 0-164-73.6-164-164s73.6-164 164-164 164 73.6 164 164-73.5 164-164 164z m0-252.3c-48.7 0-88.3 39.6-88.3 88.3s39.6 88.3 88.3 88.3 88.3-39.6 88.3-88.3-39.6-88.3-88.3-88.3z\" fill=\"#29CCB6\" p-id=\"1088\"></path><path d=\"M512 991c-11.9 0-23.7-4.2-33.3-12.5-37.9-33.2-370.6-330.6-370.6-542.6 0-222.7 181.2-403.8 403.8-403.8s403.8 181.1 403.8 403.8c0 211.9-332.6 509.4-370.6 542.6-9.3 8.3-21.2 12.5-33.1 12.5z m0-858c-167 0-302.9 135.9-302.9 302.9 0 115.2 173.8 316.3 302.8 436.5 107.7-100.9 303-309.9 303-436.5 0-167-135.8-302.9-302.9-302.9z\" fill=\"#4585F5\" p-id=\"1089\"></path></svg>",//'./Build/Cesium/ThirdParty/Draw/img/glyphicons_242_google_maps.png',
            disableDepthTestDistance: Number.POSITIVE_INFINITY,
            heightReference: Cesium.HeightReference.RELATIVE_TO_GROUND
        }
    });
    viewer.zoomTo(poi, new Cesium.HeadingPitchRange(0, Cesium.Math.toRadians(-60), 300));
}

/**
 * 获取建筑物信息
 * @param Id id
 * @param position 气泡位置
 * @param isPopup 是否使用气泡框显示
 * @param option 参数信息
 */
function getBuildInfoById(Id, position, isPopup, option) {
    $.ajax({
        type: 'get',
        url: option.url,
        data: {
            'service': 'wfs',
            'version': '1.0.0',
            'request': 'GetFeature',
            'typeName': option.typeName,
            'maxFeatures': '100000',
            'outputFormat': 'application/json',
            'viewparams': '' + option.viewparams + '\:' + Id
        },
        async: false,
        success: function (data) {
            if (isPopup && data.features.length > 0) {
                console.log(data.features[0].properties);
                viewer.popup.show(position, data.features[0].properties);
            } else {
                // $('.info-table').attr('id', data.features[0].properties.id);
                $('#eidt-value-id').val(data.features[0].properties.id);
                $('#eidt-value-x').val(data.features[0].properties.x);
                $('#eidt-value-y').val(data.features[0].properties.y);
                $('#eidt-value-z').val(data.features[0].properties.z);
                $('#eidt-value-dangju').val(data.features[0].properties.dangju);
                $('#eidt-value-dianya').val(data.features[0].properties.dianya);
                $('#eidt-value-yongtu').val(data.features[0].properties.yongtu);
                $('#eidt-value-xinghao').val(data.features[0].properties.xinghao);
                $('#eidt-value-zhonglei').val(data.features[0].properties.zhonglei);
                $('#eidt-value-height').val(data.features[0].properties.height);
                $('#eidt-value-fengji').val(data.features[0].properties.fengji);
                $('#eidt-value-lon').val(data.features[0].properties.lon);
                $('#eidt-value-lat').val(data.features[0].properties.lat);
                console.log(data);

            }
        }
    });
}

function getLineInfoById(Id, position, isPopup, option) {
    $.ajax({
        type: 'get',
        url: option.url,
        data: {
            'service': 'wfs',
            'version': '1.0.0',
            'request': 'GetFeature',
            'typeName': option.typeName,
            'maxFeatures': '100000',
            'outputFormat': 'application/json',
            'viewparams': '' + option.viewparams + '\:' + Id
        },
        async: false,
        success: function (data) {
            if (isPopup && data.features.length > 0) {
                console.log(data.features[0].properties);
                viewer.popup.show(position, data.features[0].properties);
            } else {
                // $('.info-table').attr('id', data.features[0].properties.id);
                $('#eidt-value-gid').val(data.features[0].properties.id);
                $('#eidt-value-dianyadengji').val(data.features[0].properties.dianya);
                $('#eidt-value-danwei').val(data.features[0].properties.danwei);
                $('#eidt-value-start').val(data.features[0].properties.start);
                $('#eidt-value-end').val(data.features[0].properties.end);
                $('#eidt-value-linestart').val(data.features[0].properties.linestart);
                $('#eidt-value-lineend').val(data.features[0].properties.lineend);
                $('#eidt-value-startpoint').val(data.features[0].properties.startpoint);
                $('#eidt-value-endpoint').val(data.features[0].properties.endpoint);
                // console.log(data);

            }
        }
    });
}

/**
 * 更新建筑物信息
 * @param id
 * @param x
 * @param y
 * @param z
 * @param dangju
 * @param dianya
 * @param yongtu
 * @param xinghao
 * @param zhonglei
 * @param height
 * @param fengji
 * @param lon
 * @param lat
 * @param option
 */
function updateBuildInfo(id, x, y, z, dangju, dianya, yongtu, xinghao, zhonglei, height, fengji, lon, lat, option) {
    $.ajax({
        type: 'get',
        url: option.url,
        data: {
            'service': 'wfs',
            'version': '1.0.0',
            'request': 'GetFeature',
            'typeName': option.typeName,
            'maxFeatures': '100000',
            'outputFormat': 'application/json',
            'viewparams': 'a:' + x + ';b:' + y + ';c:' + z + ';d:' + dangju + ';e:' + dianya + ';f:' + yongtu + ';g:' + xinghao + ';h:' + zhonglei + ';i:' + height + ';j:' + fengji + ';k:' + lon + ';l:' + lat + ';m:' + id
        },
        async: false,
        success: function (data) {
            console.log(data);
            if (data.features[0].properties.f_update === '{"success":"更新成功！"}') {
                alert("数据修改成功！");
                $('#editInfoBar').hide();
            } else {
                alert('数据修改失败！');
            }
        }
    });
}

function updateLineInfo(gid, dianya, danwei, start, end, linestart, lineend, startpoint, endpoint, option) {
    $.ajax({
        type: 'get',
        url: option.url,
        data: {
            'service': 'wfs',
            'version': '1.0.0',
            'request': 'GetFeature',
            'typeName': option.typeName,
            'maxFeatures': '100000',
            'outputFormat': 'application/json',
            'viewparams': 'a:' + dianya + ';b:' + danwei + ';c:' + start + ';d:' + end + ';e:' + linestart + ';f:' + lineend + ';g:' + startpoint + ';h:' + endpoint + ';i:' + gid
        },
        async: false,
        success: function (data) {
            console.log(data);
            if (data.features[0].properties.f_update === '{"success":"更新成功！"}') {
                alert("数据修改成功！");
                $('#editLineBar').hide();
            } else {
                alert('数据修改失败！');
            }
        }
    });
}

function showPOI() {
    if (!isShowPOI) {
        /**
         * 获取所有的POI点信息
         * @param option get请求所需参数
         */
        $.ajax({
            type: 'get',
            url: config.queryAll.url,
            data: {
                'service': 'wfs',
                'version': '1.0.0',
                'request': 'GetFeature',
                'typeName': config.queryAll.typeName,//"Map3D-V2.0:tower",
                'maxFeatures': '100000',
                'outputFormat': 'application/json',
            },
            async: false,
            success: function (data) {
                console.log(data);
                if (data.features.length > 0) {
                    for (let i = 0; i < data.features.length; i++) {
                        // pois.push([data.features[i].properties.id, data.features[i].properties.name, data.features[i].properties.icon, data.features[i].geometry.coordinates, data.features[i].properties.height]);
                        pois.push(data.features[i].properties);
                        createPointElement(i, data.features[i].properties.id, data.features[i].properties.fengji);
                    }
                    $('#showPOIBar').show();
                }
            }
        })
    } else {
        $('li').remove();
        pois = [];
    }
    isShowPOI = !isShowPOI;
}

function createPointElement(index, name, miaoshu) {
    let txt = ' <li> <div class="poi_item poi_item_div" id="' + index + '"> <div class="poi_item_img" id="poi_item_img">' + icon + '</div><div class="poi_item_txt" id="poi_item_txt"><strong>编号：' + name + '</strong><br><strong>描述：' + miaoshu + '</strong></div><div class="poi_item_btn" id="poi_item_btn">' + '</div></div></li>';
    $('.pois_collection').append(txt);
}

function measureDis() {

    var CreatePolyline = (function () {
        function _(positons) {
            if (!Cesium.defined(positons)) {
                throw new Cesium.DeveloperError('positions is required!');
            }
            if (positons.length < 2) {
                throw new Cesium.DeveloperError('positions 的长度必须大于等于2');
            }
            this.options = {
                polyline: {
                    show: true,
                    width: 2,
                    material: new Cesium.PolylineOutlineMaterialProperty({
                        color: Cesium.Color.AQUA,
                        outlineWidth: 0,
                        outlineColor: Cesium.Color.AQUA
                    }),
                    depthFailMaterial: new Cesium.PolylineOutlineMaterialProperty({
                        color: Cesium.Color.AQUA,
                        outlineWidth: 0,
                        outlineColor: Cesium.Color.AQUA
                    }),
                    // followSurface: false
                }
            };
            this.path = positons;
            this._init();
        }

        _.prototype._init = function () {
            var that = this;
            var positionCBP = function () {
                return that.path;
            };
            this.options.polyline.positions = new Cesium.CallbackProperty(positionCBP, false);
            viewer.entities.add(this.options);
        };

        return _;
    })();

    var isDraw = true;
    var polylinePath = [];
    var polyline = undefined;

    var handler = viewer.cesiumWidget.screenSpaceEventHandler;
    handler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_CLICK);
    handler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_DOUBLE_CLICK);

    handler.setInputAction(function (movement) {
        // var ray = viewer.scene.camera.getPickRay(movement.endPosition);
        //
        // var cartesian = viewer.scene.globe.pick(ray, viewer.scene);
        var cartesian = viewer.scene.pickPosition(movement.endPosition);
        if (cartesian) {
            if (isDraw) {
                if (polylinePath.length < 1) {
                    return;
                }
                if (!Cesium.defined(polyline)) {
                    polylinePath.push(cartesian);

                    polyline = new CreatePolyline(polylinePath);

                } else {
                    polyline.path.pop();
                    polyline.path.push(cartesian);
                }
            }
        }
    }, Cesium.ScreenSpaceEventType.MOUSE_MOVE);

    handler.setInputAction(function (movement) {
        // var ray = viewer.scene.camera.getPickRay(movement.position);
        //
        // var cartesian = viewer.scene.globe.pick(ray, viewer.scene);
        var cartesian = viewer.scene.pickPosition(movement.position);
        if (cartesian) {
            if (isDraw) {
                polylinePath.push(cartesian);
            }
        }
    }, Cesium.ScreenSpaceEventType.LEFT_CLICK);

    handler.setInputAction(function () {
        if (isDraw) {
            var distance = 0
            for (var i = 0; i < polylinePath.length - 1; i++) {
                distance += Cesium.Cartesian3.distance(polylinePath[i], polylinePath[i + 1])
            }
            alert(distance)
        }
        isDraw = false;
        polylinePath = [];
        polyline = undefined;
    }, Cesium.ScreenSpaceEventType.LEFT_DOUBLE_CLICK);
}


