/*百度坐标转火星坐标*/
x_pi = 3.14159265358979324 * 3000.0 / 180.0;

function baiduTomars(baidu_point) {
    let mars_point = {lon: 0, lat: 0};
    let x = baidu_point.lon - 0.0065;
    let y = baidu_point.lat - 0.006;
    let z = Math.sqrt(x * x + y * y) - 0.00002 * Math.sin(y * x_pi);
    let theta = Math.atan2(y, x) - 0.000003 * Math.cos(x * x_pi);
    mars_point.lon = z * Math.cos(theta);
    mars_point.lat = z * Math.sin(theta);
    return mars_point;
}

/*火星坐标转百度坐标*/
x_pi = 3.14159265358979324 * 3000.0 / 180.0;

function marsTobaidu(mars_point) {
    let baidu_point = {lon: 0, lat: 0};
    let x = mars_point.lon;
    let y = mars_point.lat;
    let z = Math.sqrt(x * x + y * y) + 0.00002 * Math.sin(y * x_pi);
    let theta = Math.atan2(y, x) + 0.000003 * Math.cos(x * x_pi);
    baidu_point.lon = z * Math.cos(theta) + 0.0065;
    baidu_point.lat = z * Math.sin(theta) + 0.006;
    return baidu_point;
}

/*地球坐标系(WGS-84)转火星坐标系(GCJ)*/
let pi = 3.14159265358979324;
let a = 6378245.0;
let ee = 0.00669342162296594323;

/*判断是否在国内，不在国内则不做偏移*/
function outOfChina(lon, lat) {
    return (lon < 72.004 || lon > 137.8347) && (lat < 0.8293 || lat > 55.8271);
}

function transformLat(x, y) {
    let ret = -100.0 + 2.0 * x + 3.0 * y + 0.2 * y * y + 0.1 * x * y + 0.2 * Math.sqrt(Math.abs(x));
    ret += (20.0 * Math.sin(6.0 * x * pi) + 20.0 * Math.sin(2.0 * x * pi)) * 2.0 / 3.0;
    ret += (20.0 * Math.sin(y * pi) + 40.0 * Math.sin(y / 3.0 * pi)) * 2.0 / 3.0;
    ret += (160.0 * Math.sin(y / 12.0 * pi) + 320 * Math.sin(y * pi / 30.0)) * 2.0 / 3.0;
    return ret;
}

function transformLon(x, y) {
    let ret = 300.0 + x + 2.0 * y + 0.1 * x * x + 0.1 * x * y + 0.1 * Math.sqrt(Math.abs(x));
    ret += (20.0 * Math.sin(6.0 * x * pi) + 20.0 * Math.sin(2.0 * x * pi)) * 2.0 / 3.0;
    ret += (20.0 * Math.sin(x * pi) + 40.0 * Math.sin(x / 3.0 * pi)) * 2.0 / 3.0;
    ret += (150.0 * Math.sin(x / 12.0 * pi) + 300.0 * Math.sin(x / 30.0 * pi)) * 2.0 / 3.0;
    return ret;
}

function transform(wgLat, wgLon) {
    let mars_point = {lon: 0, lat: 0};
    if (outOfChina(wgLat, wgLon)) {
        mars_point.lat = wgLat;
        mars_point.lon = wgLon;
        return;
    }
    let dLat = transformLat(wgLon - 105.0, wgLat - 35.0);
    let dLon = transformLon(wgLon - 105.0, wgLat - 35.0);
    let radLat = wgLat / 180.0 * pi;
    let magic = Math.sin(radLat);
    magic = 1 - ee * magic * magic;
    let sqrtMagic = Math.sqrt(magic);
    dLat = (dLat * 180.0) / ((a * (1 - ee)) / (magic * sqrtMagic) * pi);
    dLon = (dLon * 180.0) / (a / sqrtMagic * Math.cos(radLat) * pi);
    mars_point.lat = wgLat + dLat;
    mars_point.lon = wgLon + dLon;
    return mars_point;
}

/*经纬度转墨卡托投影坐标*/
function lonlatTomercator(lonlat) {
    let mercator = {x: 0, y: 0};
    let x = lonlat.x * 20037508.34 / 180;
    let y = Math.log(Math.tan((90 + lonlat.y) * Math.PI / 360)) / (Math.PI / 180);
    y = y * 20037508.34 / 180;
    mercator.x = x;
    mercator.y = y;
    return mercator;
}

/*墨卡托投影坐标转经纬度坐标*/
function mercatorTolonlat(mercator) {
    let lonlat = {x: 0, y: 0};
    let x = mercator.x / 20037508.34 * 180;
    let y = mercator.y / 20037508.34 * 180;
    y = 180 / Math.PI * (2 * Math.atan(Math.exp(y * Math.PI / 180)) - Math.PI / 2);
    lonlat.x = x;
    lonlat.y = y;
    return lonlat;
}