/**
 * POI管理
 * @param viewer 场景主视图
 * @constructor
 */
function POIEdit(viewer) {
    let _self = this;
    let icon = '<svg viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" width="28" height="28"><defs><style type="text/css"></style></defs><path id="measure-polyline-svg" d="M569.426921 276.616038c-49.018414 49.052183-49.018414 128.888486 0 177.975461 24.020066 23.952528 55.799864 36.873816 88.759533 36.873816 9.513678 0 19.094894-1.079588 28.64234-3.272533 22.940478-5.296633 43.890626-16.935718 60.58996-33.635051l0.033769-0.033769c17.070794-17.104563 28.777417-38.526455 33.905204-62.007239 9.209756-42.119283-3.475148-85.470627-33.938973-115.917056C698.366571 227.54646 618.479103 227.496317 569.426921 276.616038zM713.88501 377.773949c-2.328022 10.525728-7.624654 20.208251-15.349593 27.966958-7.523347 7.523347-16.935718 12.752442-27.225061 15.114233-19.397792 4.520967-39.10053-1.248434-53.032844-15.146978-22.097274-22.131043-22.097274-58.127885 0-80.241532 11.06501-11.06501 25.606191-16.598027 40.146349-16.598027s29.080316 5.51562 40.146349 16.581654C712.299909 339.196329 718.034517 358.762967 713.88501 377.773949z M956.212104 424.970878l-17.475-234.651274c-4.149507-56.289004-49.761334-101.798501-106.066711-105.8467L598.777389 67.653843c-42.339294-3.036149-84.441181 12.532431-114.668623 42.777269L110.447485 484.07602c-57.418734 57.418734-57.418734 150.868079 0 208.286814l221.208101 221.208101c27.798113 27.831882 64.807005 43.148729 104.143918 43.148729 39.33589 0 76.344782-15.315824 104.143918-43.148729L913.468604 540.04473C943.797353 509.715981 959.38333 467.748147 956.212104 424.970878zM864.618013 491.194138 491.091808 864.721367c-30.497595 30.497595-80.090083 30.497595-110.586654 0l-221.208101-221.208101c-30.497595-30.497595-30.497595-80.090083 0-110.586654l373.695051-373.661282c14.675234-14.709003 34.545794-22.890336 55.225789-22.890336 1.855254 0 3.744277 0.067538 5.634324 0.202615l233.859235 16.817014c22.367427 1.602498 40.483017 19.667945 42.136679 42.035372L887.323131 430.098665C889.00954 452.80276 880.744295 475.068879 864.618013 491.194138z" fill="#ffffff"></path></svg>';
    let deicon = '<svg viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" width="28" height="28"> <defs> <style type="text/css"></style> </defs> <path id="measure-polyline-svg"  d="M786.7392 333.42464 608.17408 512 786.7392 690.57536c26.56256 26.56256 26.56256 69.61152 0 96.17408-13.27104 13.27104-30.6688 19.9168-48.06656 19.9168-17.408 0-34.80576-6.63552-48.0768-19.9168L512 608.16384l-178.5856 178.5856c-13.27104 13.27104-30.6688 19.9168-48.0768 19.9168-17.39776 0-34.78528-6.63552-48.06656-19.9168-26.56256-26.55232-26.56256-69.60128 0-96.17408L415.82592 512 237.2608 333.42464c-26.56256-26.56256-26.56256-69.61152 0-96.17408 26.55232-26.54208 69.5808-26.54208 96.14336 0L512 415.83616l178.5856-178.5856c26.56256-26.54208 69.59104-26.54208 96.14336 0C813.30176 263.81312 813.30176 306.86208 786.7392 333.42464z" fill="#ffffff"></path></svg>'
    _self.viewer = viewer;
    _self.point = null;
    _self.datas = [];
    _self.poi = null;
    _self.drawLayer = new Cesium.PrimitiveCollection();
    _self.drawHelper = new DrawGeometryHelper(viewer);
    _self.viewer.scene.primitives.add(_self.drawLayer);

    /**
     * 绘制POI点
     * @param name
     * @constructor
     */
    function DrawPoint(name) {
        _self.drawHelper.startDrawingMarker({
            callback: function (position) {
                var billboards = new Cesium.BillboardCollection();
                billboards.add({
                    show: true,
                    position: position,
                    pixelOffset: new Cesium.Cartesian2(0, 0),
                    eyeOffset: new Cesium.Cartesian3(0.0, 0.0, -30.0),
                    horizontalOrigin: Cesium.HorizontalOrigin.CENTER,
                    verticalOrigin: Cesium.VerticalOrigin.BOTTOM,
                    width: 6,
                    height: 6,
                    image: "data:image/svg+xml,<svg t=\"1537323945478\" class=\"icon\" style=\"\" viewBox=\"0 0 1024 1024\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" p-id=\"1087\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" width=\"1024\" height=\"1024\"><defs><style type=\"text/css\"></style></defs><path d=\"M512 599.9c-90.4 0-164-73.6-164-164s73.6-164 164-164 164 73.6 164 164-73.5 164-164 164z m0-252.3c-48.7 0-88.3 39.6-88.3 88.3s39.6 88.3 88.3 88.3 88.3-39.6 88.3-88.3-39.6-88.3-88.3-88.3z\" fill=\"#29CCB6\" p-id=\"1088\"></path><path d=\"M512 991c-11.9 0-23.7-4.2-33.3-12.5-37.9-33.2-370.6-330.6-370.6-542.6 0-222.7 181.2-403.8 403.8-403.8s403.8 181.1 403.8 403.8c0 211.9-332.6 509.4-370.6 542.6-9.3 8.3-21.2 12.5-33.1 12.5z m0-858c-167 0-302.9 135.9-302.9 302.9 0 115.2 173.8 316.3 302.8 436.5 107.7-100.9 303-309.9 303-436.5 0-167-135.8-302.9-302.9-302.9z\" fill=\"#4585F5\" p-id=\"1089\"></path></svg>",//'./Build/Cesium/ThirdParty/Draw/img/glyphicons_242_google_maps.png',
                    color: new Cesium.Color(1.0, 1.0, 1.0, 1.0),
                    sizeInMeters: true
                });
                $('#editPOIBar').show();
                _self.point = cartesian2LonLat(position.clone());
                _self.drawLayer.add(billboards);
                closeCSS(name);

            }
        })
    }

    /**
     * 快速定位到poi点
     * @param index
     */
    function zoomTo(index) {
        if (_self.poi) {
            if (_self.viewer.entities.contains(_self.poi)) {
                _self.viewer.entities.remove(_self.poi);
                _self.poi = null;
            }
        }
        _self.poi = _self.viewer.entities.add({
            id: "test",
            position: new Cesium.Cartesian3.fromDegrees(viewer.POIManager.datas[index][3][0], viewer.POIManager.datas[index][3][1], parseInt(viewer.POIManager.datas[0][4])),
            billboard: {
                pixelOffset: new Cesium.Cartesian2(0, 0),
                eyeOffset: new Cesium.Cartesian3(0.0, 0.0, -30.0),
                horizontalOrigin: Cesium.HorizontalOrigin.CENTER,
                verticalOrigin: Cesium.VerticalOrigin.BOTTOM,
                width: 30,
                height: 30,
                image: "data:image/svg+xml,<svg t=\"1537323945478\" class=\"icon\" style=\"\" viewBox=\"0 0 1024 1024\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" p-id=\"1087\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" width=\"1024\" height=\"1024\"><defs><style type=\"text/css\"></style></defs><path d=\"M512 599.9c-90.4 0-164-73.6-164-164s73.6-164 164-164 164 73.6 164 164-73.5 164-164 164z m0-252.3c-48.7 0-88.3 39.6-88.3 88.3s39.6 88.3 88.3 88.3 88.3-39.6 88.3-88.3-39.6-88.3-88.3-88.3z\" fill=\"#29CCB6\" p-id=\"1088\"></path><path d=\"M512 991c-11.9 0-23.7-4.2-33.3-12.5-37.9-33.2-370.6-330.6-370.6-542.6 0-222.7 181.2-403.8 403.8-403.8s403.8 181.1 403.8 403.8c0 211.9-332.6 509.4-370.6 542.6-9.3 8.3-21.2 12.5-33.1 12.5z m0-858c-167 0-302.9 135.9-302.9 302.9 0 115.2 173.8 316.3 302.8 436.5 107.7-100.9 303-309.9 303-436.5 0-167-135.8-302.9-302.9-302.9z\" fill=\"#4585F5\" p-id=\"1089\"></path></svg>",//'./Build/Cesium/ThirdParty/Draw/img/glyphicons_242_google_maps.png',
                disableDepthTestDistance: Number.POSITIVE_INFINITY
            }
        });
        _self.viewer.zoomTo(_self.poi);
    }

    /**
     * 获取POI数据
     * @param name 名称
     * @param miaoshu 描述
     * @param position 位置
     * @param option 设置信息
     */
    function addPOIData(name, miaoshu, position, option) {
        $.ajax({
            type: 'get',
            url: option.url,
            data: {
                'service': 'wfs',
                'version': '1.0.0',
                'request': 'GetFeature',
                'typeName': option.typeName,
                'maxFeatures': '100000',
                'outputFormat': 'application/json',
                'viewparams': 'a:' + name + ';b:' + miaoshu + ';c:' + position[0] + ';d:' + position[1] + ';f:' + position[2]
            },
            async: false,
            success: function (data) {
                if (data.features[0].properties.f_insertinto.indexOf('成功') > 0) {
                    alert("新增标注成功！");
                    // $('#editInfoBar').hide();
                    $('#eidt-POI-name').val("");
                    $('#eidt-POI-miaoshu').val("");
                } else {
                    alert('新增标注失败！');
                }
                console.log(data);
            }
        });
    }

    /**
     * 平面坐标转经纬度坐标
     * @param cartesian 平面坐标
     * @returns {*[]}
     */
    function cartesian2LonLat(cartesian) {
        var cartographic = Cesium.Cartographic.fromCartesian(cartesian);
        var lon = Cesium.Math.toDegrees(cartographic.longitude);
        var lat = Cesium.Math.toDegrees(cartographic.latitude);
        var height = cartographic.height;
        return [lon, lat, height];
    }

    /**
     * 获取所有的POI点信息
     * @param option get请求所需参数
     */
    function getAllPOI(option) {
        $.ajax({
            type: 'get',
            url: option.url,
            data: {
                'service': 'wfs',
                'version': '1.0.0',
                'request': 'GetFeature',
                'typeName': option.typeName,
                'maxFeatures': '100000',
                'outputFormat': 'application/json',
            },
            async: false,
            success: function (data) {
                if (data.features.length > 0) {
                    for (let i = 0; i < data.features.length; i++) {
                        _self.datas.push([data.features[i].properties.id, data.features[i].properties.name, data.features[i].properties.icon, data.features[i].geometry.coordinates, data.features[i].properties.height]);
                        createPointElement(i, data.features[i].properties.name, data.features[i].properties.icon);
                    }
                    $('#showPOIBar').show();
                }
            }
        });
    }

    /**
     * 删除poi
     * @param index poi索引
     * @param option
     */
    function deletePOI(index, option) {
        $.ajax({
            type: 'get',
            url: option.url,//'http://localhost:8080/geoserver/SouthSmart/ows?',
            data: {
                'service': 'wfs',
                'version': '1.0.0',
                'request': 'GetFeature',
                'typeName': option.typeName,//'SouthSmart:POI_delect',
                'maxFeatures': '100000',
                'outputFormat': 'application/json',
                'viewparams': 'a:' + _self.datas[parseInt(index)][0]
            },
            success: function (data) {
                if (data.features[0].properties.f_delect.indexOf('成功') > 0) {
                    alert("删除标注成功！");
                } else {
                    alert('删除标注失败！');
                }
            }
        });
    }

    /**
     * 关闭css效果
     * @param name
     */
    function closeCSS(name) {
        $(('#' + name + "-svg")).css('fill', '#ffffff');
        $('.poi').removeClass('poi');
    }

    /**
     * 根据信息动态创建li
     * @param index 数据索引信息
     * @param name  属性信息
     * @param miaoshu 属性信息
     */
    function createPointElement(index, name, miaoshu) {
        let txt = ' <li> <div class="poi_item poi_item_div" id="' + index + '"> <div class="poi_item_img" id="poi_item_img">' + icon + '</div><div class="poi_item_txt" id="poi_item_txt"><strong>名称：' + name + '</strong><br><strong>描述：' + miaoshu + '</strong></div><div class="poi_item_btn" id="poi_item_btn">' + deicon + '</div></div></li>';
        $('.poi_collection').append(txt);
    }

    /**
     * 绘制POI
     * @param name
     */
    POIEdit.prototype.drawPoint = function (name) {
        _self.Clean();
        DrawPoint(name);
    };
    /**
     * 获取所以POI数据
     */
    POIEdit.prototype.getPOI = function (option) {
        _self.Clean();
        _self.data = getAllPOI(option);
    };
    /**
     * 关闭POI管理界面
     */
    POIEdit.prototype.closePOIBar = function () {
        _self.Clean();
        $('#showPOIBar').hide();
        _self.datas = [];
    };
    /**
     * 新增poi
     * @param name
     * @param miaoshu
     * @param option 参数设置
     */
    POIEdit.prototype.addPOI = function (name, miaoshu, option) {
        _self.Clean();
        $('#editPOIBar').hide();
        addPOIData(name, miaoshu, _self.point, option)
    };
    /**
     * 快速缩放至poi
     * @param index poi索引
     */
    POIEdit.prototype.zoomToPOI = function (index) {
        zoomTo(index)
    };
    /**
     * 删除poi
     * @param index poi索引
     */
    POIEdit.prototype.deletePOI = function (index, option) {
        deletePOI(index, option);
        _self.Clean();
        getPOI();
    };
    /**
     * 清除场景中存在的poi数据
     * @constructor
     */
    POIEdit.prototype.Clean = function () {
        if (_self.poi) {
            if (_self.viewer.entities.contains(_self.poi)) {
                _self.viewer.entities.remove(_self.poi);
                _self.poi = null;
            }
        }
        _self.drawHelper.stopDrawing();
        _self.drawLayer.removeAll();
        $('li').remove();
        _self.datas = [];
    };
}