/**
 * 通视分析
 * @constructor
 */
function SightAnalysis() {
    let _self = this;
    _self.viewer = viewer;
    _self.startPoint = null;
    _self.endPoint = null;
    _self.polyline = [];
    _self.drawLayer = new Cesium.PrimitiveCollection();
    _self.drawHelper = new DrawGeometryHelper(viewer);
    _self.viewer.scene.primitives.add(_self.drawLayer);

    /**
     * 绘制线段
     * @param name
     * @constructor
     */
    function DrawPolyLine(name) {
        _self.drawHelper.startDrawingPolyline({
            callback: function (position, state) {
                console.log(position, state);
                _self.polyline.push(position.clone());
                if (!_self.startPoint) {
                    _self.startPoint = position.clone();
                } else {
                    _self.drawHelper.stopDrawing();
                    _self.endPoint = position.clone();
                    let startP = _self.startPoint, endP = _self.endPoint;
                    let startWP = Cesium.SceneTransforms.wgs84ToWindowCoordinates(_self.viewer.scene, startP);
                    let endWP = Cesium.SceneTransforms.wgs84ToWindowCoordinates(_self.viewer.scene, endP);
                    let num = parseInt(Cesium.Cartesian3.distance(_self.startPoint, _self.endPoint));
                    let start = cartesian2LonLat(_self.startPoint), end = cartesian2LonLat(_self.endPoint);
                    let point = sight(new Cesium.Cartesian2(startWP.x, startWP.y), new Cesium.Cartesian2(endWP.x, endWP.y), num, start, end);
                    console.log(point);
                    console.log(num);
                    console.log(start);
                    console.log(end);
                    if (point) {
                        let p = new Cesium.Cartesian3.fromDegrees(point[0], point[1], point[2]);
                        var green = new Cesium.Primitive({
                            geometryInstances: new Cesium.GeometryInstance({
                                geometry: new Cesium.PolylineGeometry({
                                    positions: [_self.startPoint, p],//坐标必须两个和两个以上
                                    width: 2,//线宽
                                    vertexFormat: Cesium.PolylineColorAppearance.VERTEX_FORMAT
                                }),
                                attributes: {
                                    color: Cesium.ColorGeometryInstanceAttribute.fromColor(Cesium.Color.GREEN),//color  必须设置 不然没有效果
                                }
                            }),
                            appearance: new Cesium.PolylineColorAppearance({
                                translucent: false
                            })
                        });
                        var red = new Cesium.Primitive({
                            geometryInstances: new Cesium.GeometryInstance({
                                geometry: new Cesium.PolylineGeometry({
                                    positions: [_self.endPoint, p],//坐标必须两个和两个以上
                                    width: 2,//线宽
                                    vertexFormat: Cesium.PolylineColorAppearance.VERTEX_FORMAT
                                }),
                                attributes: {
                                    color: Cesium.ColorGeometryInstanceAttribute.fromColor(Cesium.Color.RED),//color  必须设置 不然没有效果
                                }
                            }),
                            appearance: new Cesium.PolylineColorAppearance({
                                translucent: false
                            })
                        });
                        _self.drawLayer.add(green);
                        _self.drawLayer.add(red);
                    } else {
                        var red = new Cesium.Primitive({
                            geometryInstances: new Cesium.GeometryInstance({
                                geometry: new Cesium.PolylineGeometry({
                                    positions: [_self.endPoint, _self.startPoint],//坐标必须两个和两个以上
                                    width: 2,//线宽
                                    vertexFormat: Cesium.PolylineColorAppearance.VERTEX_FORMAT
                                }),
                                attributes: {
                                    color: Cesium.ColorGeometryInstanceAttribute.fromColor(Cesium.Color.GREEN),//color  必须设置 不然没有效果
                                }
                            }),
                            appearance: new Cesium.PolylineColorAppearance({
                                translucent: false
                            })
                        });
                        _self.drawLayer.add(red);
                    }
                    closeCSS(name);
                }
            }
        });
    }

    /**
     * 关闭css
     * @param name
     */
    function closeCSS(name) {
        $(('#' + name + "-svg")).css('fill', '#ffffff');
        $('.sight').removeClass('sight');
    }

    /**
     * 通视分析
     * @param startWP 屏幕起点
     * @param endWP 屏幕终点
     * @param num 插值书
     * @param start 起点
     * @param end 终点
     * @returns {*[]} 分析结果
     */
    function sight(startWP, endWP, num, start, end) {
        for (var i = 0; i < num; i++) {
            let lon = Cesium.Math.lerp(startWP.x, endWP.x, 1 / num * (i + 1));
            let lat = Cesium.Math.lerp(startWP.y, endWP.y, 1 / num * (i + 1));
            let height = Cesium.Math.lerp(start[2], end[2], 1 / num * (i + 1));
            let p = viewer.scene.pickPosition(new Cesium.Cartesian2(lon, lat));
            let h = cartesian2LonLat(p)[2];
            console.log(height, h);
            if (h > height) {
                let lo = Cesium.Math.lerp(start[0], end[0], 1 / num * (i + 1));
                let la = Cesium.Math.lerp(start[1], end[1], 1 / num * (i + 1));
                return [lo, la, height];
            }
        }
    }

    /**
     * 平面坐标转经纬度
     * @param cartesian
     * @returns {*[]}
     */
    function cartesian2LonLat(cartesian) {
        var cartographic = Cesium.Cartographic.fromCartesian(cartesian);
        var lon = Cesium.Math.toDegrees(cartographic.longitude);
        var lat = Cesium.Math.toDegrees(cartographic.latitude);
        return [lon, lat, cartographic.height];
    }

    /**
     * 绘制线段
     * @param name
     * @constructor
     */
    SightAnalysis.prototype.DrawPolyline = function (name) {
        DrawPolyLine(name);
    };
    /**
     * 清除通视分析结果
     */
    SightAnalysis.prototype.clean = function () {
        _self.drawHelper.stopDrawing();
        _self.polyline = [];
        _self.startPoint = null;
        _self.endPoint = null;
        _self.drawLayer.removeAll();
    };
}