/**
 * 程序功能主要js文件
 */

/** 场景配置，矢量白模，倾斜摄影模型，场景事件hander */
let config = null, vector = null, photography = null, handler = null;
/**场景功能开关*/
let isAnalysisMeasure = false, isBuildInfoShow = false, isAnalysisBuffer = false, isAnalysisRoad = false,
    isAnalysisHeight = false, isAnalysisProfile = false, isAnalysisSight = false, isAnalysisFlood = false,
    isAnalysisRoam = false, isEditBuildInfo = false, isPOIManager = false;
/** click选中要素*/
let selectedFeature = {
    feature: undefined,
    originalColor: Cesium.Color.RED.withAlpha(0.01)
};
/** move选中要素 */
let highlightedFeature = {
    feature: undefined,
    originalColor: Cesium.Color.RED.withAlpha(0.01)
};
/** 获取场景配置参数 */
$.getJSON("Build/Static/js/config.json", "", function (data) {
    config = data;
    $(document).ready(function () {
        initialize();
    });
});

/**
 * 系统初始化
 */
function initialize() {
    let ESRIImg = new Cesium.ArcGisMapServerImageryProvider({
        name: config.ESRIImg.name,
        url: config.ESRIImg.url,
        layer: config.ESRIImg.layer,
        style: config.ESRIImg.style,
        format: config.ESRIImg.format,
        tileMatrixSetID: config.ESRIImg.tileMatrixSetID,
        minimumLevel: config.ESRIImg.minimumLevel,
        maximumLevel: config.ESRIImg.maximumLevel,
        enablePickFeatures: config.ESRIImg.enablePickFeatures,
    });
    let TDTVec = new Cesium.ImageryLayer(new Cesium.WebMapTileServiceImageryProvider({
        name: config.TDTVec.name,
        url: config.TDTVec.url,
        layer: config.TDTVec.layer,
        style: config.TDTVec.style,
        format: config.TDTVec.format,
        tileMatrixSetID: config.TDTVec.tileMatrixSetID,
        minimumLevel: config.TDTVec.minimumLevel,
        maximumLevel: config.TDTVec.maximumLevel,
    }), {
        show: config.TDTVec.show
    });
    viewer = new Cesium.Viewer('mainScene', {
        sceneMode: Cesium.SceneMode.SCENE3D,
        scene3DOnly: true,
        fullscreenButton: false,
        homeButton: false,
        animation: false,
        baseLayerPicker: false,
        geocoder: false,
        timeline: false,
        sceneModePicker: false,
        navigationHelpButton: false,
        selectionIndicator: false,
        infoBox: false,
        imageryProvider: ESRIImg,
        contextOptions: {
            webgl: {
                alpha: true,
                depth: false,
                stencil: true,
                antialias: true,
                premultipliedAlpha: true,
                preserveDrawingBuffer: true,
                failIfMajorPerformanceCaveat: true
            }
        },
        skyBox: new Cesium.SkyBox({
            sources: {
                // positiveX: 'Build/Cesium/Assets/Textures/SkyBox/tycho2t3_80_px.jpg',
                // negativeX: 'Build/Cesium/Assets/Textures/SkyBox/tycho2t3_80_mx.jpg',
                // positiveY: 'Build/Cesium/Assets/Textures/SkyBox/tycho2t3_80_py.jpg',
                // negativeY: 'Build/Cesium/Assets/Textures/SkyBox/tycho2t3_80_my.jpg',
                // positiveZ: 'Build/Cesium/Assets/Textures/SkyBox/tycho2t3_80_pz.jpg',
                // negativeZ: 'Build/Cesium/Assets/Textures/SkyBox/tycho2t3_80_mz.jpg',
                positiveX: 'Build/Cesium/Assets/Textures/SkyBox/sky.jpg',
                negativeX: 'Build/Cesium/Assets/Textures/SkyBox/sky.jpg',
                positiveY: 'Build/Cesium/Assets/Textures/SkyBox/sky.jpg',
                negativeY: 'Build/Cesium/Assets/Textures/SkyBox/sky.jpg',
                positiveZ: 'Build/Cesium/Assets/Textures/SkyBox/sky.jpg',
                negativeZ: 'Build/Cesium/Assets/Textures/SkyBox/sky.jpg'
            }
        }),
    });
    Cesium.viewerCesiumNavigationMixin(viewer, {
        enableCompass: true,
        enableZoomControls: true,
        enableDistanceLegend: true,
        enableCompassOuterRing: true,
        defaultPositionView: {
            destination: new Cesium.Cartesian3.fromDegrees(config.InitialPosition.lon, config.InitialPosition.lat, config.InitialPosition.height),
            orientation: new Cesium.HeadingPitchRoll.fromDegrees(config.InitialOrientation.heading, config.InitialOrientation.pitch, config.InitialOrientation.roll)
        }
    });
    viewer.terrainProvider = new Cesium.CesiumTerrainProvider({
        url: config.Terrain,
        requestWaterMask: false,
        requestVertexNormals: false
    });
    viewer.scene.moon.show = false;
    viewer.imageryLayers.add(TDTVec);
    viewer.scene.globe.depthTestAgainstTerrain = true;
    viewer.scene.screenSpaceCameraController.enableLook = false;
    viewer.scene.screenSpaceCameraController.enableTranslate = false;
    viewer.cesiumWidget.creditContainer.style.display = "none";
    viewer.scene.globe.baseColor = Cesium.Color.fromCssColorString(config.globe.baseColor);
    viewer.cesiumWidget.screenSpaceEventHandler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_DOUBLE_CLICK);
    photography = viewer.scene.primitives.add(new Cesium.Cesium3DTileset({
        url: config.MainModelData.photography.url,
        colorBlendMode: Cesium.Cesium3DTileColorBlendMode.HIGHLIGHT
    }));
    vector = viewer.scene.primitives.add(new Cesium.Cesium3DTileset({
        show: false,
        url: config.MainModelData.vector.url,
        colorBlendMode: Cesium.Cesium3DTileColorBlendMode.HIGHLIGHT
    }));
    vector.style = new Cesium.Cesium3DTileStyle({
        color: " color('transparent', 0.01)",
    });
    vector.readyPromise.then(function (tileset) {
        let x = config.MainModelData.vector.offset.x,
            y = config.MainModelData.vector.offset.y,
            z = config.MainModelData.vector.offset.z;
        let boundingSphere = tileset.boundingSphere;
        let cartographic = Cesium.Cartographic.fromCartesian(boundingSphere.center);
        let surface = Cesium.Cartesian3.fromRadians(cartographic.longitude, cartographic.latitude, 0.0);
        let offset = Cesium.Cartesian3.fromRadians((cartographic.longitude + x), (cartographic.latitude + y), z);
        let translation = Cesium.Cartesian3.subtract(offset, surface, new Cesium.Cartesian3());
        vector.modelMatrix = Cesium.Matrix4.fromTranslation(translation);

    });
    photography.readyPromise.then(function (tileset) {
        let x = config.MainModelData.photography.offset.x,
            y = config.MainModelData.photography.offset.y,
            z = config.MainModelData.photography.offset.z;
        let boundingSphere = tileset.boundingSphere;
        let cartographic = Cesium.Cartographic.fromCartesian(boundingSphere.center);
        let surface = Cesium.Cartesian3.fromRadians(cartographic.longitude, cartographic.latitude, 0.0);
        let offset = Cesium.Cartesian3.fromRadians((cartographic.longitude + x), (cartographic.latitude + y), z);
        let translation = Cesium.Cartesian3.subtract(offset, surface, new Cesium.Cartesian3());
        photography.modelMatrix = Cesium.Matrix4.fromTranslation(translation);
        viewer.camera.viewBoundingSphere(boundingSphere);
        viewer.camera.lookAtTransform(Cesium.Matrix4.IDENTITY);
    });
    viewer.popup = new Popup(viewer);
    viewer.queryLocation = new LocationQuery(viewer, config.locationQuery);
    handler = new Cesium.ScreenSpaceEventHandler(viewer.scene.canvas);
}

/**
 * 模型单体化开关
 */
function showBuildInfo() {
    if (isBuildInfoShow) {
        if (Cesium.defined(selectedFeature.feature)) {
            selectedFeature.feature.color = selectedFeature.originalColor;
            selectedFeature.feature = undefined;
        }
        if (Cesium.defined(highlightedFeature.feature)) {
            highlightedFeature.feature.color = highlightedFeature.originalColor;
            highlightedFeature.feature = undefined;
        }
        viewer.popup.close();
        handler.removeInputAction(Cesium.ScreenSpaceEventType.MOUSE_MOVE);
        handler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_CLICK);
    } else {
        photography.show = true;
        handler.setInputAction(function onMove(movement) {
            var position = viewer.scene.pickPosition(movement.endPosition);
            if (position) {
                if (isBuildInfoShow) {
                    var pickedFeature = viewer.scene.pick(movement.endPosition);
                    if (Cesium.defined(pickedFeature)) {
                        if (selectedFeature.feature === pickedFeature || highlightedFeature.feature === pickedFeature || !pickedFeature.getProperty('selected')) {
                            return;
                        }
                        if (Cesium.defined(highlightedFeature.feature)) {
                            highlightedFeature.feature.color = highlightedFeature.originalColor;
                            highlightedFeature.feature = undefined;
                        }
                        if (pickedFeature !== selectedFeature.feature) {
                            highlightedFeature.feature = pickedFeature;
                            Cesium.Color.clone(pickedFeature.color, highlightedFeature.originalColor);
                            pickedFeature.color = Cesium.Color.fromAlpha(Cesium.Color.YELLOW, 0.3);
                        }
                    }
                }
            }
        }, Cesium.ScreenSpaceEventType.MOUSE_MOVE);
        handler.setInputAction(function onClick(movement) {
            var position = viewer.scene.pickPosition(movement.position);
            if (position) {
                if (isBuildInfoShow) {
                    if (Cesium.defined(selectedFeature.feature)) {
                        selectedFeature.feature.color = selectedFeature.originalColor;
                        selectedFeature.feature = undefined;
                    }
                    var pickedFeature = viewer.scene.pick(movement.position);
                    if (selectedFeature.feature === pickedFeature || !pickedFeature.getProperty('selected')) {
                        return;
                    }
                    selectedFeature.feature = pickedFeature;
                    if (pickedFeature === highlightedFeature.feature) {
                        Cesium.Color.clone(highlightedFeature.originalColor, selectedFeature.originalColor);
                        highlightedFeature.feature = undefined;
                    } else {
                        Cesium.Color.clone(pickedFeature.color, selectedFeature.originalColor);
                    }
                    if (pickedFeature instanceof Cesium.Cesium3DTileFeature) {
                        // var propertyNames = pickedFeature.getPropertyNames();
                        // var length = propertyNames.length;
                        // for (var i = 0; i < length; ++i) {
                        //     var propertyName = propertyNames[i];
                        //     if (propertyName === "selected" || propertyName === "Id") {
                        //         continue;
                        //     }
                        //     data[propertyName] = pickedFeature.getProperty(propertyName);
                        // }
                        pickedFeature.color = Cesium.Color.fromAlpha(Cesium.Color.LIME, 0.3);
                        getBuildInfoById(pickedFeature.getProperty("Id"), position, true, config.BuildInfo)
                    }
                }
            }
        }, Cesium.ScreenSpaceEventType.LEFT_CLICK);
    }
    vector.show = !vector.show;
    isBuildInfoShow = !isBuildInfoShow;
}

/**
 * 缓冲区分析开关
 * @param radius 缓冲半径
 */
function analysisBuffer(radius) {
    if (isAnalysisBuffer) {
        CleanBuffer();
        viewer.bufferAnalysis = null;
    } else {
        viewer.bufferAnalysis = new BufferAnalysis(viewer);
        setBufferRadius(radius);
    }
    isAnalysisBuffer = !isAnalysisBuffer
}

/**
 * 设置缓冲区分析缓冲半径
 * @param radius
 */
function setBufferRadius(radius) {
    if (viewer.bufferAnalysis) {
        viewer.bufferAnalysis.setBufferRadius(radius);
    }
}

/**
 * 开始绘制缓冲区
 * @param name
 * @constructor
 */
function StartBuffer(name) {
    switch (name) {
        case "buffer-point":
            viewer.bufferAnalysis.PointBuffer(name);
            break;
        case "buffer-polyline":
            viewer.bufferAnalysis.PolylineBuffer(name);
            break;
        case "buffer-polygon":
            viewer.bufferAnalysis.PolygonBuffer(name);
            break;
    }
}

/**
 * 清除缓冲区
 * @constructor
 */
function CleanBuffer() {
    viewer.bufferAnalysis.Clean();
}

/**
 * 路径分析开关
 */
function analysisRoad() {
    if (isAnalysisRoad) {
        CleanRoad();
        viewer.roadAnalysis = null;
    } else {
        viewer.roadAnalysis = new RoadAnalysis(viewer, config.RoadAnalysis);
    }
    isAnalysisRoad = !isAnalysisRoad
}

/**
 * 绘制起点终点
 * @param name 起点/终点
 */
function setPoint(name) {
    viewer.roadAnalysis.setdrawPoint(name);
}

/**
 * 路径分析
 * @constructor
 */
function RoadQuery() {
    viewer.roadAnalysis.query();
}

/**
 * 清除起点终点和生成路径
 * @constructor
 */
function CleanRoad() {
    viewer.roadAnalysis.clean();
}

/**
 * 开始控高分析
 * @param height 默认控高高度
 */
function analysisHeight(height) {
    if (isAnalysisHeight) {
        CleanHeight();
        viewer.heightAnalysis = null;
    } else {
        viewer.heightAnalysis = new HeightAnalysis(viewer, vector, config.MainModelData.vector.offset.z, config.HeightAnalysis);
        setHeight(height);
    }
    vector.show = !vector.show;
    isAnalysisHeight = !isAnalysisHeight;
}

/**
 * 设置控高分析高度值
 * @param height 设置的控高高度
 */
function setHeight(height) {
    viewer.heightAnalysis.setHeight(height);
}

/**
 * 绘制控高范围
 * @param name 绘制按钮id
 */
function drawHeightGeometry(name) {
    viewer.heightAnalysis.clean();
    viewer.heightAnalysis.drawGeometry(name);
}

/**
 * 清除控高结果
 * @constructor setHeight()
 */
function CleanHeight() {
    viewer.heightAnalysis.clean();
}

/**
 * 剖面分析
 */
function analysisProfile() {
    if (isAnalysisProfile) {
        CleanProfile();
        viewer.profileAnalysis = null;
    } else {
        let echart = echarts.init(document.getElementById('echart-profile'));
        viewer.profileAnalysis = new ProfileAnalysis(viewer, echart);
    }
    isAnalysisProfile = !isAnalysisProfile;
}

/**
 * 绘制切线
 * @param name 绘制切线按钮的ID
 * @constructor ProfileAnalysis
 */
function StartProfile(name) {
    CleanProfile();
    viewer.profileAnalysis.drawPolyline(name);
}

/**
 * 清除剖面分析结果
 * @constructor ProfileAnalysis（）
 */
function CleanProfile() {
    viewer.profileAnalysis.clean();
}

/**
 * 通视分析
 */
function analysisSight() {
    if (isAnalysisSight) {
        CleanSight();
        viewer.sightAnalysis = null;
    } else {
        viewer.sightAnalysis = new SightAnalysis(viewer);
    }
    isAnalysisSight = !isAnalysisSight;
}

/**
 * 绘制通视分析线
 * @param name 绘制按钮ID
 * @constructor SightAnalysis()
 */
function StartSight(name) {
    CleanSight();
    viewer.sightAnalysis.DrawPolyline(name);
}

/**
 * 清除通视分析结果
 * @constructor SightAnalysis()
 */
function CleanSight() {
    viewer.sightAnalysis.clean();
}

/**
 * 淹没分析
 * @param speed 水淹速度
 */
function analysisFlood(speed) {
    if (isAnalysisFlood) {
        CleanFlood();
        viewer.floodAnalysis = null;
    } else {
        viewer.floodAnalysis = new FloodAnalysis(viewer, config.MainModelData.vector.offset.z);
        setFloodSpeed(speed);
    }
    isAnalysisFlood = !isAnalysisFlood;
}

/**
 * 设置水淹速度
 * @param speed
 */
function setFloodSpeed(speed) {
    viewer.floodAnalysis.setFloodSpeed(speed);
}

/**
 * 开始模拟水淹
 * @param id 模拟按钮id
 * @constructor FloodAnalysis()
 */
function StartFlood(id) {
    viewer.floodAnalysis.startFlood(id);
}

/**
 * 暂停水淹
 * @constructor
 */
function PauseFlood() {
    viewer.floodAnalysis.pauseFlood();
}

/**
 * 停止水淹
 * @param id 停止模拟按钮id
 * @constructor  FloodAnalysis
 */
function StopFlood(id) {
    viewer.floodAnalysis.stopFlood(id);
}

/**
 * 清除水淹结果
 * @constructor FloodAnalysis
 */
function CleanFlood() {
    viewer.floodAnalysis.Clean();
}

/**
 * 绘制水淹范围
 * @param name 点击水淹按钮id
 */
function drawFloodPolygon(name) {
    CleanFlood();
    viewer.floodAnalysis.DrawPolygon(name);
}

/**
 * 飞行
 */
function analysisRoam() {
    if (isAnalysisRoam) {
        CleanRoam();
        viewer.roamAnalysis = null;
    } else {
        viewer.roamAnalysis = new RoamAnalysis(viewer);
    }
    isAnalysisRoam = !isAnalysisRoam;
}

/**
 * 开始飞行
 * @param name 开始飞行按钮id
 * @constructor RoamAnalysis()
 */
function StartRoam(name) {
    viewer.roamAnalysis.startRoam(name);
}

/**
 * 暂停飞行
 * @constructor RoamAnalysis()
 */
function PauseRoam() {
    viewer.roamAnalysis.pauseRoam();
}

/**
 * 停止飞行
 * @param name 停止飞行按钮id
 * @constructor RoamAnalysis()
 */
function StopRoam(name) {
    viewer.roamAnalysis.stopRoam(name);
}

/**
 * 加载默认飞行路径
 * @constructor RoamAnalysis()
 */
function LoadDefaultRoamRoad() {
    viewer.roamAnalysis.loadDefaultRoamRoad();
}

/**
 * 自定义飞行路径
 * @param name 绘制飞行路径按钮id
 * @constructor RoamAnalysis()
 */
function DrawRoamRoad(name) {
    viewer.roamAnalysis.drawRoamRoad(name);
}

/**
 * 清除飞行
 * @constructor RoamAnalysis()
 */
function CleanRoam() {
    viewer.roamAnalysis.Clean();
}

/**
 * 地图测量
 */
function mapMeasure() {
    if (isAnalysisMeasure) {
        CleanMeasure();
        viewer.mapMeasure = null;
    } else {
        viewer.mapMeasure = new MapMeasure(viewer);
    }
    isAnalysisMeasure = !isAnalysisMeasure
}


/**
 * 地图测量
 * @param name
 * @constructor
 */
function Measure(name) {
    switch (name) {
        case "measure-polyline":
            viewer.mapMeasure.LinearMeasure("measure-polyline");
            break;
        case "measure-height":
            viewer.mapMeasure.HeightMeasure("measure-height");
            break;
        case "measure-polygon":
            viewer.mapMeasure.AreaMeasure("measure-polygon");
            break;
    }
}

/**
 * 清除测量结果
 * @constructor MapMeasure()
 */
function CleanMeasure() {
    viewer.mapMeasure.Clean();
}

/**
 * 二三维联动
 */
function startLinkageMap() {
    if (viewer.hawkEyeMap) {
        endHawkEyeMap()
        viewer.hawkEyeMap = null
    }
    viewer.linkageby2D3D = new Linkageby2D3D(viewer, config.linkageby2D3D);
    viewer.linkageby2D3D.spiltScreen();
}

/**
 * 结束二三维联动
 */
function endLinkageMap() {
    viewer.linkageby2D3D.reset();
    viewer.linkageby2D3D = null;
}

/**
 * 地图鹰眼
 */
function startHawkEyeMap() {
    if (viewer.linkageby2D3D) {
        endLinkageMap();
        viewer.linkageby2D3D = null
    }
    viewer.hawkEyeMap = new Linkageby2D3D(viewer, config.hawkEyeMap);
    viewer.hawkEyeMap.spiltScreen();
}

/**
 * 结束地图鹰眼
 */
function endHawkEyeMap() {
    viewer.hawkEyeMap.reset();
    viewer.hawkEyeMap = null;

}


/**
 * 图层管理
 * @param name 图层名称
 * @param show 是否显示
 */
function layerManager(name, show) {
    switch (name) {
        case "vector":
            viewer.imageryLayers._layers[config.TDTVec.index].show = show;
            viewer.imageryLayers._layers[config.ESRIImg.index].show = !show;
            break;
        case "image":
            viewer.imageryLayers._layers[config.TDTVec.index].show = !show;
            viewer.imageryLayers._layers[config.ESRIImg.index].show = show;
            break;
        case "photography":
            photography.show = show;
            break;
    }
}

/**
 * 建筑物属性修改
 * @constructor
 */
function EditBuildInfo() {
    if (isEditBuildInfo) {
        if (Cesium.defined(selectedFeature.feature)) {
            selectedFeature.feature.color = selectedFeature.originalColor;
            selectedFeature.feature = undefined;
        }
        if (Cesium.defined(highlightedFeature.feature)) {
            highlightedFeature.feature.color = highlightedFeature.originalColor;
            highlightedFeature.feature = undefined;
        }
        // viewer.popup.close();
        handler.removeInputAction(Cesium.ScreenSpaceEventType.MOUSE_MOVE);
        handler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_CLICK);
        $('#editInfoBar').hide();
    } else {
        photography.show = true;
        handler.setInputAction(function onMove(movement) {
            var position = viewer.scene.pickPosition(movement.endPosition);
            if (position) {
                if (isEditBuildInfo) {
                    var pickedFeature = viewer.scene.pick(movement.endPosition);
                    if (Cesium.defined(pickedFeature)) {
                        if (selectedFeature.feature === pickedFeature || highlightedFeature.feature === pickedFeature || !pickedFeature.getProperty('selected')) {
                            return;
                        }
                        if (Cesium.defined(highlightedFeature.feature)) {
                            highlightedFeature.feature.color = highlightedFeature.originalColor;
                            highlightedFeature.feature = undefined;
                        }
                        if (pickedFeature !== selectedFeature.feature) {
                            highlightedFeature.feature = pickedFeature;
                            Cesium.Color.clone(pickedFeature.color, highlightedFeature.originalColor);
                            pickedFeature.color = Cesium.Color.fromAlpha(Cesium.Color.YELLOW, 0.3);
                        }
                    }
                }
            }
        }, Cesium.ScreenSpaceEventType.MOUSE_MOVE);
        handler.setInputAction(function onClick(movement) {
            var position = viewer.scene.pickPosition(movement.position);
            if (position) {
                if (isEditBuildInfo) {
                    if (Cesium.defined(selectedFeature.feature)) {
                        selectedFeature.feature.color = selectedFeature.originalColor;
                        selectedFeature.feature = undefined;
                    }
                    var pickedFeature = viewer.scene.pick(movement.position);
                    if (selectedFeature.feature === pickedFeature || !pickedFeature.getProperty('selected')) {
                        return;
                    }
                    selectedFeature.feature = pickedFeature;
                    if (pickedFeature === highlightedFeature.feature) {
                        Cesium.Color.clone(highlightedFeature.originalColor, selectedFeature.originalColor);
                        highlightedFeature.feature = undefined;
                    } else {
                        Cesium.Color.clone(pickedFeature.color, selectedFeature.originalColor);
                    }
                    var data = {};
                    if (pickedFeature instanceof Cesium.Cesium3DTileFeature) {
                        var propertyNames = pickedFeature.getPropertyNames();
                        var length = propertyNames.length;
                        for (var i = 0; i < length; ++i) {
                            var propertyName = propertyNames[i];
                            // if (propertyName === "selected" || propertyName === "Id") {
                            //     continue;
                            // }
                            data[propertyName] = pickedFeature.getProperty(propertyName);
                        }
                        pickedFeature.color = Cesium.Color.fromAlpha(Cesium.Color.LIME, 0.3);
                        getBuildInfoById(pickedFeature.getProperty("Id"), [], false, config.BuildInfo);
                        $('#editInfoBar').show();
                    }
                }
            }
        }, Cesium.ScreenSpaceEventType.LEFT_CLICK);
    }
    vector.show = !vector.show;
    isEditBuildInfo = !isEditBuildInfo;
}

/**
 * 更新建筑物信息
 * @param id
 * @param name
 * @param miaoshu
 * @param maxheight
 * @param height
 * @param altitude
 */
function updateBuild(id, name, miaoshu, maxheight, height, altitude) {
    updateBuildInfo(id, name, miaoshu, maxheight, height, altitude, config.EditInfo)
}

/**
 * 标注管理
 * @constructor POIEdit()
 */
function POIManager() {
    if (isPOIManager) {
        CleanPOIManager();
        viewer.POIManager.closePOIBar();
        viewer.POIManager = null;
        isPOIManager = !isPOIManager;
    } else {
        viewer.POIManager = new POIEdit(viewer);
        isPOIManager = !isPOIManager;
    }
}

/**
 * 添加POI
 * @param name
 * @param miaoshu
 */
function addPOI(name, miaoshu) {
    viewer.POIManager.addPOI(name, miaoshu, config.addPOI);
}

/**
 * 快速定位到poi点
 * @param index 点所在的索引位置
 */
function zoomToPOI(index) {
    viewer.POIManager.zoomToPOI(index);
}

/**
 * 删除poi点
 * @param index 点所在的索引位置
 */
function deletePOI(index) {
    viewer.POIManager.deletePOI(index, config.deletePOI);
}

/**
 * 获取所有的poi点信息
 */
function getPOI() {
    viewer.POIManager.getPOI(config.getAllPOI);
}

/**
 * 绘制poi点
 * @param name 绘制点按钮id
 */
function drawPOI(name) {
    viewer.POIManager.drawPoint(name);
}

/**
 * 关闭poi管理界面
 */
function closePOIBar() {
    viewer.POIManager.closePOIBar();
}

/**
 * 清除poi管理
 * @constructor
 */
function CleanPOIManager() {
    viewer.POIManager.Clean();
}

/**
 * 获取建筑物信息
 * @param Id id
 * @param position 气泡位置
 * @param isPopup 是否使用气泡框显示
 * @param option 参数信息
 */
function getBuildInfoById(Id, position, isPopup, option) {
    $.ajax({
        type: 'get',
        url: option.url,
        data: {
            'service': 'wfs',
            'version': '1.0.0',
            'request': 'GetFeature',
            'typeName': option.typeName,
            'maxFeatures': '100000',
            'outputFormat': 'application/json',
            'viewparams': '' + option.viewparams + '\:' + Id
        },
        async: false,
        success: function (data) {
            if (isPopup) {
                viewer.popup.show(position, data.features[0].properties);
            } else {
                $('.info-table').attr('id', data.features[0].properties.id);
                $('#eidt-value-name').val(data.features[0].properties.name);
                $('#eidt-value-height').val(data.features[0].properties.height);
                $('#eidt-value-miaoshu').val(data.features[0].properties.miaoshu);
                $('#eidt-value-altitude').val(data.features[0].properties.altitude);
                $('#eidt-value-maxheight').val(data.features[0].properties.maxheight);

            }
        }
    });
}

/**
 * 更新建筑物信息
 * @param id id
 * @param name 名称
 * @param miaoshu 描述信息
 * @param maxheight 最大高度
 * @param height 高度
 * @param altitude 海拔
 * @param option 参数信息
 */
function updateBuildInfo(id, name, miaoshu, maxheight, height, altitude, option) {
    $.ajax({
        type: 'get',
        url: option.url,
        data: {
            'service': 'wfs',
            'version': '1.0.0',
            'request': 'GetFeature',
            'typeName': option.typeName,
            'maxFeatures': '100000',
            'outputFormat': 'application/json',
            'viewparams': 'a:' + height + ';b:' + maxheight + ';c:' + miaoshu + ';d:' + name + ';e:' + altitude + ';g:' + id
        },
        async: false,
        success: function (data) {
            console.log(data);
            if (data.features[0].properties.f_update === '{"success":"更新成功！"}') {
                alert("数据修改成功！");
                $('#editInfoBar').hide();
            } else {
                alert('数据修改失败！');
            }
        }
    });
}



