$(document).ready(function () {
    /**
     * 工具条点击事件
     */
    $('.tooldrop').click(function () {
        let id = $(this).attr("id").replace('tool', 'bar');
        if ($(".show").attr("id") !== id) {
            $(".show").removeClass("show");
        }
        if ($('.active').attr("id") !== $(this).attr("id")) {
            $(".active").removeClass("active");
        }
        if ($(this).hasClass('active')) {
            $('.' + id).removeClass('show');
            $(this).removeClass('active');
        } else {
            $('.' + id).addClass('show');
            $(this).addClass('active');
        }
    });

    /**
     * 工具条按钮点击事件
     */
    $('.toolbtn').click(function () {
        let id = $(this).attr("id");
        switch (id) {
            case "tool_home":
                flyToHome();
                break;
            case "tool_north":
                setNorth();
                break;
            case "tool_full":
                if ($(this).hasClass('full')) {
                    exitFullscreen(document.getElementById("mainscene"));
                    $(this).removeClass('full');
                } else {
                    launchIntoFullscreen(document.getElementById("mainscene"));
                    $(this).addClass('full');
                }
                break;
            case "tool_export":
                saveScene();
                break;
        }
    });
    /**
     * 全景按钮点击事件
     */
    $('.toolpanorama').click(function () {
        if ($(this).hasClass('panorama')) {
            setPanorama(false);
            $('.toolbtn').show();
            $(this).removeClass('panorama');
        } else {
            setPanorama(true);
            $('.toolbtn').hide();
            $(this).addClass('panorama');
        }
    });

    /**
     * 图层树
     */
    $('#tree_layer').tree({
        data: [
            {
                "id": 1,
                "text": "地图",
                "iconCls": "icon-file",
                "children": [
                    {
                        "id": 11,
                        "text": "影像底图",
                        "checked": false
                    },
                    {
                        "id": 12,
                        "text": "矢量底图",
                        "checked": false
                    }
                ]
            },
            {
                "id": 2,
                "text": "点云",
                "iconCls": "icon-file",
                "children": [
                    {
                        "id": 20,
                        "text": "第一段公路",
                        "checked": true
                    },
                    {
                        "id": 21,
                        "text": "第二段公路",
                        "checked": true
                    }, {
                        "id": 22,
                        "text": "第三段公路",
                        "checked": true
                    }, {
                        "id": 23,
                        "text": "第四段公路",
                        "checked": true
                    }, {
                        "id": 24,
                        "text": "第五段公路",
                        "checked": true
                    }, {
                        "id": 25,
                        "text": "第六段公路",
                        "checked": true
                    },
                ]
            },
            {
                "id": 3,
                "text": "模型",
                "iconCls": "icon-file",
                "children": [
                    {
                        "id": 31,
                        "text": "测试",
                        "checked": false
                    },
                ]
            },
            {
                "id": 4,
                "text": "矢量",
                "iconCls": "icon-file",
                "children": [
                    {
                        "id": 40,
                        "text": "护栏",
                        "checked": false
                    }, {
                        "id": 41,
                        "text": "道线",
                        "checked": false
                    }, {
                        "id": 42,
                        "text": "路面",
                        "checked": false
                    }, {
                        "id": 43,
                        "text": "花坛",
                        "checked": false
                    }, {
                        "id": 44,
                        "text": "路缘石",
                        "checked": false
                    }, {
                        "id": 45,
                        "text": "道路标线",
                        "checked": false
                    }, {
                        "id": 46,
                        "text": "杆",
                        "checked": false
                    }, {
                        "id": 47,
                        "text": "房屋",
                        "checked": false
                    }
                ]
            }
        ],
        onlyLeafCheck: true,
        onCheck: function (node, checked) {
            if (checked && (node.id === 11 || node.id === 12)) {
                changeLayer(node.id);
                let id = (node.id === 11) ? 12 : 11;
                $('#tree_layer').tree('uncheck', $('#tree_layer').tree('find', id).target);
            } else if (parseInt(node.id / 10) === 2) {
                showTile(node.id % 10, checked);
            } else if (parseInt(node.id / 10) === 3) {
                showModel(checked);
            } else if (parseInt(node.id / 10) === 4) {
                showVector(node.id % 10, checked);
            }
        }
    })

});