module.exports = {
  renderFiles: [
    'package.json',
    'README.md',
    'src/router/index.js',
    'src/store/index.js',
    'src/api/index.js'
  ],
  filters: {
    serviceMonitor: {
      'vue': 'src/views/ServiceMonitor/**/*',
      'router': 'src/router/serviceMonitor.js',
      'api': 'src/api/serviceMonitor.js',
      'store': ''
    },
    serviceManage: {
      'vue': 'src/views/ServiceManage/**/*',
      'router': 'src/router/serviceManage.js',
      'api': 'src/api/serviceManage.js',
      'store': ''
    },
    systemMonitor: {
      'vue': 'src/views/SystemMonitor/**/*',
      'router': 'src/router/systemMonitor.js',
      'api': 'src/api/systemMonitor.js',
      'store': ''
    },
    serverMonitor: {
      'vue': 'src/views/ServerMonitor/**/*',
      'router': 'src/router/serverMonitor.js',
      'api': 'src/api/serverMonitor.js',
      'store': ''
    }
  },
  prompts: {
    name: {
      type: 'string',
      required: true,
      message: 'Project name'
    },
    description: {
      type: 'string',
      required: false,
      message: 'Project description',
      default: 'A vuejs backstage project',
    },
    author: {
      type: 'string',
      message: 'Author'
    },
    serviceManage: {
      type: 'confirm',
      message: '是否安装包含【服务管理】模块'
    },
    serviceMonitor: {
      type: 'confirm',
      message: '是否安装包含【服务监测】模块'
    },
    systemMonitor: {
      type: 'confirm',
      message: '是否安装包含【系统监控】模块'
    },
    serverMonitor: {
      type: 'confirm',
      message: '是否安装包含【服务器监控】模块'
    }
  }
}