// https://eslint.org/docs/user-guide/configuring

module.exports = {
  root: true,
  parserOptions: {
    parser: 'babel-eslint'
  },
  env: {
    browser: true,
  },
  // https://github.com/vuejs/eslint-plugin-vue#priority-a-essential-error-prevention
  // consider switching to `plugin:vue/strongly-recommended` or `plugin:vue/recommended` for stricter rules.
  extends: [
    'plugin:vue/essential',
    'standard'
  ],
  // required to lint *.vue files
  plugins: [
    'vue'
  ],
  // add your custom rules here
  rules: {
    // allow async-await
    'generator-star-spacing': 'off',
    // 缩进忽略
    'indent': 'off',
    // 忽略\在正则字符串使用
    'no-useless-escape': 'off',
    // 变量var let const忽略
    'no-unused-vars': 'off',
    'one-var': 'off',
    'no-trailing-spaces': 'off',
    // 最多可以空两行（在块里允许开始结束空行）
    'no-multiple-empty-lines': ['error', {
      'max': 2,
      'maxBOF': 1,
      'maxEOF': 1
    }],
    'no-multi-spaces': ['error', {
      'ignoreEOLComments': true,
      'exceptions': {
        'Property': true,
        'VariableDeclarator': true,
        'ImportDeclaration': true
      }
    }],
    'no-unused-expressions': ['error', {
      'allowShortCircuit': true,
      'allowTernary': true,
      'allowTaggedTemplates': true
    }],
    // 字符串用单引号
    'quotes': ['error', 'single', {
      'avoidEscape': true,
      'allowTemplateLiterals': true
    }],
    // 不允许使用分号结束
    'semi': ['error', 'never'],
    // 函数前空格忽略
    'space-before-function-paren': 'off',
    // allow debugger during development
    'no-debugger': process.env.NODE_ENV === 'production' ? 'error' : 'off'
  }
}
