import axios from 'axios'

// 携带cookie信息
axios.defaults.withCredentials = true
// 设置全局的请求次数，请求的间隙
axios.defaults.retry = 4
axios.defaults.retryDelay = 1000

// 请求超时拦截，重新请求
axios.interceptors.response.use(undefined, function axiosRetryInterceptor (err) {
  var config = err.config
  // If config does not exist or the retry option is not set, reject
  if (!config || !config.retry) return Promise.reject(err)

  // Set the variable for keeping track of the retry count
  config.__retryCount = config.__retryCount || 0

  // Check if we've maxed out the total number of retries
  if (config.__retryCount >= config.retry) {
    // Reject with the error
    return Promise.reject(err)
  }

  // Increase the retry count
  config.__retryCount += 1

  // Create new promise to handle exponential backoff
  var backoff = new Promise(function (resolve) {
    setTimeout(function () {
      resolve()
    }, config.retryDelay || 1)
  })

  // Return the promise in which recalls axios to retry the request
  return backoff.then(function () {
    return axios(config)
  })
})

// API_ROOT in .pubtrc.js
// let root = process.env.NODE_ENV === 'production' ? '{{ API_ROOT }}' : '172.16.10.132:8010'
let root = '172.16.10.132:8010'
let url = 'http://' + root

const config = {
  url: url,
  gisAnalyzeUrl: url + '/Gis_V2/Gis_analyze', // 服务监测
  gisServiceUrl: url + '/Gis_V2/Gis_service', // 服务管理
  gisSystemUrl: url + '/Gis_V2/Gis', // 系统安全
  gisSysCommon: url + '/Gis_V2/Gis_SysCommon', // 系统监控
  gisSerCommon: url + '/monitor',  // 服务器监控
  
  // 旧接口
  maintenanceUrl: url + '/maintenance',
  // 在线监控 
  wsUrl: 'ws://' + root + '/Gis_V2/webSocket'
}

export default config
