import axios from 'axios'
import config from './config'

import systemSafety from './systemSafety'
{{#serviceMonitor}}
import serviceMonitor from './serviceMonitor'
{{/serviceMonitor}}
{{#serviceManage}}
import serviceManage from './serviceManage'
{{/serviceManage}}
{{#systemMonitor}}
import systemMonitor from './systemMonitor'
{{/systemMonitor}}
{{#serverMonitor}}
import serverMonitor from './serverMonitor'
{{/serverMonitor}}

const CancelToken = axios.CancelToken

const maintenanceApi = config.maintenanceUrl
const wsUrl = config.wsUrl

const Api = {
  maintenanceApi: maintenanceApi,
  wsUrl: wsUrl,

  _doGetPromise (url, params, options) {
    const timeout = options && options.timeout ? options.timeout : 60000
    return new Promise((resolve, reject) => {
      axios.get(url, {
        timeout: timeout,
        params: params,
        cancelToken: new CancelToken(function executor (c) {
        })
      }).then(response => {
        resolve(response.data)
      }).catch(response => {
        console.error('ajax error:', response)
        reject(response)
      })
    })
  },

  _doPostPromise (url, formData) {
    return new Promise((resolve, reject) => {
      axios.post(url, formData, {
        emulateJSON: false,
        emulateHTTP: false
      }).then(res => {
        resolve(res.data)
      }).catch(res => {
        console.log('post error:', res)
        reject(res)
      })
    })
  },

  {{#serviceMonitor}}
  /* --------------服务监控----------- */
  ...serviceMonitor,
  {{/serviceMonitor}}
  {{#serviceManage}}
  /* --------------服务管理----------- */
  ...serviceManage,
  {{/serviceManage}}
  {{#systemMonitor}}
  /* --------------系统监控----------- */
  ...systemMonitor,
  {{/systemMonitor}}
  {{#serverMonitor}}
  /* --------------服务器监控----------- */
  ...serverMonitor,
  {{/serverMonitor}}
  /* --------------系统安全----------- */
  ...systemSafety,
  
  // 图层管理——模块树
  getAllZtree () {
    return this._doPostPromise(maintenanceApi + '/LayerService/getAllZtree', {})
  },
  // 图层管理——修改
  updateLayerInfo (layerId, layerCode, layerName, layerUrl, layerType, layerDefinitions) {
    return this._doPostPromise(maintenanceApi + '/LayerService/updateLayerInfo', {
      layerId: layerId,
      layerCode: layerCode,
      layerName: layerName,
      layerUrl: layerUrl,
      layerType: layerType,
      layerDefinitions: layerDefinitions
    })
  },
  // 图层管理——删除
  delLayer (layerId) {
    return this._doPostPromise(maintenanceApi + '/LayerService/delLayer', {
      layerId: layerId
    })
  },
  // 图层管理——增加分类、增加图层
  saveLayerInfo (pid, type, layerCode, layerName, layerUrl, layerType, layerDefinitions) {
    return this._doPostPromise(maintenanceApi + '/LayerService/saveLayerInfo', {
      pid: pid,
      type: type,
      layerCode: layerCode,
      layerName: layerName,
      layerUrl: layerUrl,
      layerType: layerType,
      layerDefinitions: layerDefinitions
    })
  }
}
export default Api
