import config from './config'

const gisSerCommon = config.gisSerCommon

export default {
  // 服务器列表 
  getselectServersByPage (index, pageSize) {
    return this._doGetPromise(gisSerCommon + '/serverinfo/selectServersByPage', {
      index: index,
      pageSize: pageSize
    })
  },
  /* --------------监控图表----------- */
  // 查询CPU使用率
  getSelectCpuInfo (flag, timefrom, timeto) {
    return this._doGetPromise(gisSerCommon + '/cpuinfo/selectCpuInfo', {
      flag: flag,
      timefrom: timefrom,
      timeto: timeto
    })
  },
  // 查询CPU使用率 
  getSelectMemoryInfo (flag, timefrom, timeto) {
    return this._doGetPromise(gisSerCommon + '/memoryinfo/selectMemoryInfo', {
      flag: flag,
      timefrom: timefrom,
      timeto: timeto
    })
  },
  // 查询磁盘名称
  getDisksName (flag, timefrom, timeto) {
    return this._doGetPromise(gisSerCommon + '/diskinfo/getDisksName', {
      flag: flag,
      timefrom: timefrom,
      timeto: timeto
    })
  },
  // 查询磁盘使用率
  getSelectDiskInfo (flag, timefrom, timeto, diskname) {
    return this._doGetPromise(gisSerCommon + '/diskinfo/selectDiskInfo', {
      flag: flag, 
      timefrom: timefrom,
      timeto: timeto,
      diskname: diskname
    })
  },
  // 查询网络名称
  getNetsName (flag, timefrom, timeto) {
    return this._doGetPromise(gisSerCommon + '/netinfo/getNetsName', {
      flag: flag,
      timefrom: timefrom,
      timeto: timeto
    })
  },
  // 查询网络情况
  getSelectNetInfo (flag, timefrom, timeto, netname) {
    return this._doGetPromise(gisSerCommon + '/netinfo/selectNetInfo', {
      flag: flag,
      timefrom: timefrom,
      timeto: timeto,
      netname: netname
    })
  },
  // 查询Tcp连接数
  getSelectTcpInfo (flag, timefrom, timeto) {
    return this._doGetPromise(gisSerCommon + '/tcpinfo/selectTcpInfo', {
      flag: flag,
      timefrom: timefrom,
      timeto: timeto
    })
  },
  // 进程监控 
  getSelectProcessInfo (flag, timefrom, timeto) {
    return this._doGetPromise(gisSerCommon + '/processinfo/selectProcessInfo', {
      flag: flag,
      timefrom: timefrom,
      timeto: timeto
    })
  },

  /* --------------报警规则----------- */
  // 查询报警项目规则 
  getAlarmItem () {
    return this._doGetPromise(gisSerCommon + '/alarmrule/getAlarmItem')
  },
  // 查询主机名称
  getServersItem () {
    return this._doGetPromise(gisSerCommon + '/serverinfo/getServersItem')
  },
  // 查询报警规则列表 
  getselectRuleByPage (index, pageSize, hostid) {
    return this._doGetPromise(gisSerCommon + '/alarmrule/selectRuleByPage', {
      index: index,
      pagesize: pageSize,
      hostid: hostid
    })
  },
  // 提交报警规则表单 
  getAlarmRulesSubmit (formData) {
    return this._doPostPromise(gisSerCommon + '/alarmrule/insertAlarmRule', formData)
  },
  // 查看报警规则 
  getRuleByID (ruleid) {
    return this._doGetPromise(gisSerCommon + '/alarmrule/getRuleByID', {
      ruleid: ruleid
    })
  }, 
  // 修改报警规则 
  updateRule (formData) {
    return this._doPostPromise(gisSerCommon + '/alarmrule/updateRule', formData)
  },
  // 单条报警规则删除 
  deleteRule (ruleid) {
    return this._doGetPromise(gisSerCommon + '/alarmrule/deleteRule', {
      ruleid: ruleid
    })
  },
  // 批量删除规则 
  deleteRuleBatch (ruleids) {
    return this._doGetPromise(gisSerCommon + '/alarmrule/deleteRuleBatch', {
      ruleids: ruleids
    })
  },
  // 报警历史列表 
  selectHistoryByPage (index, pageSize, ruleid, rulename, createtime, createtimeto, flag) {
    return this._doGetPromise(gisSerCommon + '/alarmhistory/selectHistoryByPage', {
      index: index,
      pageSize: pageSize,
      ruleid: ruleid,
      rulename: rulename,
      createtime: createtime,
      createtimeto: createtimeto,
      flag: flag   
    })
  }
}
