import config from './config'

const gisServiceUrl = config.gisServiceUrl

export default {
  
  // 服务访问统计———单个服务目录树
  getdirectoryAndServicesTree (directoryid) {
    return this._doGetPromise(gisServiceUrl + '/getdirectoryAndServicesTree', {
      directoryid: directoryid
    })
  },
  // 在线监控——60s
  getOnlineMonitor60s () {
    return this._doGetPromise(gisServiceUrl + '/getRedisLogsCount_60s', {})
  },

  /* --------------服务管理------------ */
  // 资源目录管理——获取目录树
  getCatalogTree () {
    return this._doGetPromise(gisServiceUrl + '/getDirectoryTree', {})
  },
  // 资源目录管理——新建目录节点
  saveCatalogService (formData) {
    return this._doPostPromise(gisServiceUrl + '/saveDirectory', formData)
  },
  // 资源目录管理——修改目录节点
  editCatalog (formData) {
    return this._doPostPromise(gisServiceUrl + '/updateDirectoryData', formData)
  },
  // 资源目录管理——删除目录节点
  deleteCatalog (ids) {
    return this._doGetPromise(gisServiceUrl + '/deleteDirectoryData', {
      ids: ids
    })
  },
  // 服务注册——列表查询 
  getManageRegisterService (index, pageSize, name, directoryid, auditstatus, sdate, edate) {
    return this._doGetPromise(gisServiceUrl + '/getServicePage', {
      index: index,
      pageSize: pageSize,
      name: name,
      directoryid: directoryid,
      auditstatus: auditstatus,
      sdate: sdate,
      edate: edate
    })
  },
  // 服务注册——表单里删除行操作
  deleteManageRegisterService (ids) {
    return this._doGetPromise(gisServiceUrl + '/deleteServiceData', {
      ids: ids
    })
  },
  // 服务注册——注册
  registerManageRegisterService (formData) {
    return this._doPostPromise(gisServiceUrl + '/saveService', formData)
  },
  // 服务注册——点击修改显示内容
  showManageRegisterService (entityid) {
    return this._doGetPromise(gisServiceUrl + '/showServiceData', {
      entityid: entityid
    })
  },
  // 服务注册——修改
  editManageRegisterService (formData) {
    return this._doPostPromise(gisServiceUrl + '/updateServiceData', formData)
  },
  // 服务申请审批——列表查询
  getApplicationApprovalList (index, pageSize, name, directoryid, auditstatus, sdate, edate, userid) {
    return this._doGetPromise(gisServiceUrl + '/getServiceApplyPage', {
      index: index,
      pageSize: pageSize,
      name: name,
      directoryid: directoryid,
      auditstatus: auditstatus,
      sdate: sdate,
      edate: edate,
      userid: userid
    })
  },
  // 服务申请审批——审批状态    
  editApplicationApprovalService (formData) {
    return this._doPostPromise(gisServiceUrl + '/auditServiceApply', formData)
  },
  // 服务申请审批——删除
  deleteApplicatApprovalService (ids) {
    return this._doGetPromise(gisServiceUrl + '/deleteServiceApplyData', {
      ids: ids
    })
  },
  // 服务申请审批——查看详细信息
  getMoreInformation (entityid, id) {
    return this._doGetPromise(gisServiceUrl + '/showServiceApplyData', {
      entityid: entityid,
      id: id
    })
  }
}
