import config from './config'

const gisAnalyzeUrl = config.gisAnalyzeUrl

export default {
  // 服务访问统计——服务访问总数
  getServicesCount () {
    return this._doGetPromise(gisAnalyzeUrl + '/getServicesCount', {})
  },
  // 服务访问统计——请求成功和响应失败
  getAnalyzeValue (name) {
    return this._doGetPromise(gisAnalyzeUrl + '/getAnalyzeValue', {
      name: name
    })
  },
  // 服务访问统计——接入系统数
  getSysCount () {
    return this._doGetPromise(gisAnalyzeUrl + '/getSysCount', {})
  },
  // 服务访问统计——每天服务访问总量 getAnalyzeList?name=ALLNUM&catalogtype=0&date=20180410
  getAccessStTotal (name, catalogtype, sdate, edate) {
    return this._doGetPromise(gisAnalyzeUrl + '/getAnalyzeList', {
      name: name,
      catalogtype: catalogtype,
      sdate: sdate,
      edate: edate
    })
  },
  // 服务访问统计——访问量前10的服务
  getAccessStTop10service (name, sdate, edate) {
    return this._doGetPromise(gisAnalyzeUrl + '/getAnalyzeTop_Num', {
      name: name,
      sdate: sdate,
      edate: edate
    })
  },
  // 服务访问统计——单个服务访问总量
  getAnalyzeSingleServiceNum (sdate, edate, serviceid) {
    return this._doGetPromise(gisAnalyzeUrl + '/getAnalyzeSingleServiceNum', {
      sdate: sdate,
      edate: edate,
      serviceid: serviceid
    })
  },
  // 服务访问统计——单个服务访问耗时
  getAnalyzeSingleServiceTime (sdate, edate, serviceid) {
    return this._doGetPromise(gisAnalyzeUrl + '/getAnalyzeSingleServiceTime', {
      sdate: sdate,
      edate: edate,
      serviceid: serviceid
    })
  },
  // 服务访问统计——应用系统
  getAppTotalaccessbyTime (sdate, edate) {
    return this._doGetPromise(gisAnalyzeUrl + '/getAnalyzeSys_Num', {
      sdate: sdate,
      edate: edate
    })
  }
}
