import config from './config'

const gisSystemUrl = config.gisSystemUrl

export default {
  /* --------------登录接口------------ */
  getLoginApi (name, pwd) {
    return this._doGetPromise(gisSystemUrl + '/checkuser', {
      name: name,
      pwd: pwd
    })
  },
  // 判断token是否失效
  getLoginIsTimeout (token) {
    return this._doGetPromise(gisSystemUrl + '/checkuserOnline', {
      token: token
    })
  },
  // 修改密码
  modifyUserPassword (userguid, sourcePwd, targetPwd) {
    return this._doGetPromise(gisSystemUrl + '/modifyUserPassword', {
      userguid: userguid,
      source_pwd: sourcePwd,
      target_pwd: targetPwd
    })
  },

  // 用户管理——机构树
  getOrganTree () {
    return this._doGetPromise(gisSystemUrl + '/getOrganTree', {})
  },
  // 用户管理——添加机构
  saveOrganInfo (formData) {
    return this._doPostPromise(gisSystemUrl + '/saveOrganInfo', formData)
  },
  // 用户管理——修改机构
  updateOrganData (formData) {
    return this._doPostPromise(gisSystemUrl + '/updateOrganData', formData)
  },
  // 用户管理——删除机构
  deleteOrganData (ids) {
    return this._doGetPromise(gisSystemUrl + '/deleteOrganData', {
      ids: ids
    })
  },
  // 用户管理——查询机构详情
  showOrganData (entityid) {
    return this._doGetPromise(gisSystemUrl + '/showOrganData', {
      entityid: entityid
    })
  },
  // 用户管理——列表查询
  getUserServiceList (index, pagesize, regionid, loginname, status) {
    return this._doGetPromise(gisSystemUrl + '/getUserPage', {
      index: index,
      pagesize: pagesize,
      regionid: regionid,
      loginname: loginname,
      status: status
    })
  },
  // 用户管理——添加用户
  addUserService (formData) {
    return this._doPostPromise(gisSystemUrl + '/saveUserInfo', formData)
  },
  // 用户管理——展示用户
  showUserData (entityid) {
    return this._doGetPromise(gisSystemUrl + '/showUserData', {
      entityid: entityid
    })
  },
  // 用户管理——修改用户
  editUserService (formData) {
    return this._doPostPromise(gisSystemUrl + '/updateUserData', formData)
  },
  // 用户管理——删除用户
  deleteUserService (ids) {
    return this._doGetPromise(gisSystemUrl + '/deleteData', {
      ids: ids
    })
  },
  // 用户管理——获取用户的角色
  getRoleSelect (userid, roletype) {
    return this._doGetPromise(gisSystemUrl + '/getRoleofuser', {
      userid: userid,
      roletype: roletype
    })
  },
  // 用户管理——保存用户或机构与角色关系
  saveRoleRelaOpr (userid, roleid) {
    return this._doGetPromise(gisSystemUrl + '/saveRoleUserRelaOpr', {
      userid: userid,
      roleid: roleid
    })
  },

  // 角色管理——获取角色列表
  getRoleViewList (index, pagesize, rolename, roletype, showType) {
    return this._doGetPromise(gisSystemUrl + '/getRolePage', {
      index: index,
      pagesize: pagesize,
      rolename: rolename,
      roletype: roletype,
      showType: showType
    })
  },
  // 角色管理——添加角色
  saveRole (formData) {
    return this._doPostPromise(gisSystemUrl + '/saveRoleInfo', formData)
  },
  // 角色管理——修改角色
  editRole (formData) {
    return this._doPostPromise(gisSystemUrl + '/updateRoleData', formData)
  },
  // 角色管理——删除角色
  deleteRole (ids) {
    return this._doGetPromise(gisSystemUrl + '/deleteRoleData', {
      ids: ids
    })
  },
  // 角色管理——功能目录树
  getAllCatalog (userid, roletype) {
    return this._doGetPromise(gisSystemUrl + '/getModuleTree', {
      userid: userid,
      roletype: roletype
    })
  },
  // 角色管理——选中功能角色权限
  getAllRoleMoudle (roleid, roletype) {
    return this._doGetPromise(gisSystemUrl + '/getModuleOfRoles', {
      roleid: roleid,
      roletype: roletype
    })
  },
  // 系统模块管理——模块树
  getTree (userId, roletype) {
    return this._doGetPromise(gisSystemUrl + '/getModuleTree', {
      userId: userId,
      roletype: roletype
    })
  },
  // 角色管理——保存选中功能角色权限 
  savePermiss (roleid, moduleid) {
    return this._doGetPromise(gisSystemUrl + '/saveModuleRoleRelaOpr', {
      roleid: roleid,
      moduleid: moduleid
    })
  },
  // 系统模块管理——展示数据
  showModuleData (entityid) {
    return this._doGetPromise(gisSystemUrl + '/showModuleData', {
      entityid: entityid
    })
  },
  // 系统模块管理——新建保存
  saveMoudle (formData) {
    return this._doPostPromise(gisSystemUrl + '/saveModuleInfo', formData)
  },
  // 系统模块管理——编辑模块
  updateMoudle (formData) {
    return this._doPostPromise(gisSystemUrl + '/updateModuleData', formData)
  },
  // 系统模块管理——删除模块
  checkDeleteMoudle (ids) {
    return this._doGetPromise(gisSystemUrl + '/deleteModuleData', {
      ids: ids
    })
  }
}
