// The Vue build version to load with the `import` command
// (runtime-only or standalone) has been set in webpack.base.conf with an alias.
import Vue from 'vue'
import Vuex from 'vuex'
import App from './App'
import VueProgressBar from 'vue-progressbar'
import router from './router'
import store from './store/index'

import ElementUI from 'element-ui'
import 'element-ui/lib/theme-chalk/index.css'

import './assets/css/index.scss'
import '../static/theme/blue-index.css'
// import './assets/css/theme.scss'

Vue.config.productionTip = false


Vue.use(ElementUI)
Vue.use(Vuex)

const pgOptions = {
  color: '#33eaaf',
  failedColor: '#874b4b',
  thickness: '2px',
  transition: {
    speed: '0.25s',
    opacity: '0.6s',
    termination: 300
  },
  autoRevert: true,
  location: 'top',
  inverse: false
}

Vue.use(VueProgressBar, pgOptions)

/* eslint-disable no-new */
new Vue({
  el: '#app',
  router,
  store,
  components: { App },
  template: '<App/>'
})
