import Vue from 'vue'
import Router from 'vue-router'

import Login from '@/components/Login.vue'
import Err404 from '@/components/404.vue'
import Permission from '@/components/Permission.vue'

import SystemSafety from './systemSafety'
{{#serviceMonitor}}
import ServiceMonitor from './serviceMonitor'
{{/serviceMonitor}}
{{#serviceManage}}
import ServiceManage from './serviceManage'
{{/serviceManage}}
{{#systemMonitor}}
import SystemMonitor from './systemMonitor'
{{/systemMonitor}}
{{#serverMonitor}}
import ServerMonitor from './serverMonitor'
{{/serverMonitor}}

Vue.use(Router)

export default new Router({
  routes: [
    {
      path: '/',
      name: 'App',
      redirect: '/serviceMonitor'
    }, 
    {{#serviceMonitor}}
    ServiceMonitor,
    {{/serviceMonitor}}
    {{#serviceManage}}
    ServiceManage,
    {{/serviceManage}}
    {{#systemMonitor}}
    SystemMonitor,
    {{/systemMonitor}}
    {{#serverMonitor}}
    ServerMonitor,
    {{/serverMonitor}}
    SystemSafety,
    {
      path: '/login',
      name: 'Login',
      component: Login
    }, {
      path: '*',
      name: 'all',
      component: Err404,
      redirect: '/404'
    }, {
      path: '/404',
      name: 'err404',
      component: Err404
    }, {
      path: '/permission',
      name: 'Permission',
      component: Permission
    }
  ]
})
