/*!
 * echartsLayer.js v3.0.1
 * (c) 2017 Polan Zen
 * Released under the MIT License.
 */
/* (function(global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
    typeof define === 'function' && define.amd ? define(factory) :
    global.Echarts3Layer = factory();
}(this, (function () { 'use strict';

var _map = null,
    _ec = null,
    _echartsContainer = null;

function Echarts3Layer(map, echarts) {
    
    _init(map, echarts);
}

function _init(map, echarts) {
    // 在arcgis map上创建 echarts 图层
    
}

return Echarts3Layer;

}))); */

import * as esriLoader from 'esri-loader'

export default {
    _echartsContainer: null,
    _map: null,
    _ec: null,
    init(map, echarts) {
        this._map = map;
        this._echartsContainer = document.createElement("div");
        let _echartsContainer = this._echartsContainer;
        _echartsContainer.style.position = "absolute";
        _echartsContainer.style.height = map.height + "px";
        _echartsContainer.style.width = map.width + "px";
        _echartsContainer.style.top = 0;
        _echartsContainer.style.left = 0;
        map.__container.appendChild(_echartsContainer);

        this._ec = echarts.init(_echartsContainer);
        this.initECharts();
    },
    getEchartsContainer() {
        return this._echartsContainer;
    },
    getMap() {
        return this._map;
    },
    geoCoord2Pixel(gps) {
        esriLoader.dojoRequire(['esri/geometry/Point'], (Point) => {
            var points = new Point(gps[0], gps[1]),
                mapPoints = this._map.toScreen(points);
            return [mapPoints.x, mapPoints.y];
        })
    },
    pixel2GeoCoord(points) {
        esriLoader.dojoRequire(['esri/geometry/ScreenPoint'], (ScreenPoint) => {
            var gps = new ScreenPoint(points[0], points[1]),
                sreenPoints = this._map.toMap(gps);
            return [sreenPoints.x, sreenPoints.y];
        })
    },
    initECharts() {
        esriLoader.dojoRequire(['dojo/_base/lang', 'esri/geometry/Point'], (Lang, Point) => {
            // this._ec = Lang.init.apply(this, arguments);
            this._ec.Geo.prototype.dataToPoint = (points) => {
                let point = new Point(points[0], points[1]),
                    mapPoints = this._map.toScreen(point);
                return [mapPoints.x, mapPoints.y];
            }
            this._bindEvent();
        })
    },
    getECharts() {
        return this._ec;
    },
    clear() {
        this._ec.clear();
    },
    setOption(options, bool) {
        this._ec.setOption(options, bool);
    },
    _bindEvent() {
        this._map.on("zoom-start", (e) => {
            this._echartsContainer.style.visibility = "hidden"
        });

        this._map.on("zoom-end", (e) => {
            this._ec.resize();
            this._echartsContainer.style.visibility = "visible"
        });

        this._map.on("pan", (e) => {
            this._echartsContainer.style.visibility = "hidden"
        });

        this._map.on("pan-end", (e) => {
            this._ec.resize();
            this._echartsContainer.style.visibility = "visible"
        });

        this._map.on("resize", (e) => {
            let dom = this._echartsContainer.parentNode.parentNode.parentNode,
                mapOffset = [-parseInt(dom.style.left) || 0, -parseInt(dom.style.top) || 0];
            
            this._echartsContainer.style.left = mapOffset[0] + "px";
            this._echartsContainer.style.top = mapOffset[1] + "px";
            setTimeout( () => {
                this._map.resize();
                this._map.reposition();
                this._ec.resize()
            }, 200)
            this._echartsContainer.style.visibility = "visible"
        });

        this._ec.getZr().on('click', function () {});
        this._ec.getZr().on('dragstart', function () {});
        this._ec.getZr().on('dragend', function () {});

        this._ec.getZr().on('mousewheel', (e) => {
            esriLoader.dojoRequire(['esri/geometry/Point'], (Point) => {
                let lastMousePos = this._map.toMap(new Point(e.event.x, e.event.y)),
                    map = this._map,
                    delta = e.wheelDelta,
                    level = map.getZoom();
                delta = delta > 0 ? Math.ceil(delta) : Math.floor(delta);
                delta = Math.max(Math.min(delta, 4), -4);
                delta = Math.max(map.getMinZoom(), Math.min(map.getMaxZoom(), level + delta)) - level;

                map.setZoom(level + delta);
            })
        });
    }
}