// The Vue build version to load with the `import` command
// (runtime-only or standalone) has been set in webpack.base.conf with an alias.
import Vue from 'vue';
import App from './App';
import './utils/init';
import ElemetUI from 'element-ui';
import 'element-ui/packages/theme-chalk/lib/index.css';

import VueProgressBar from 'vue-progressbar';

import SmartForm from 'smart-form';
import 'smart-form/lib/smartForm.css';
// import scss
import './styles/index.scss';
import './utils/expression';

Vue.config.productionTip = false;

Vue.use(ElemetUI, {
  size: 'medium',
  zIndex: 4000
});

Vue.use(SmartForm);

const vPopts = {
  color: '#8fcdfc',
  failedColor: '#874b4b',
  thickness: '2px',
  transition: {
    speed: '0.1s',
    opacity: '0.3s',
    termination: 300
  },
  autoRevert: true,
  location: 'top',
  inverse: false,
  autoFinish: true
};

Vue.use(VueProgressBar, vPopts);

/* eslint-disable no-new */
new Vue({
  el: '#formapp',
  components: {
    App
  },
  template: '<App/>'
});
