const utils = {
  /**
   * 判断数据是否为空，一般数据是object/array
   * @param {Object/Array}
   */
  isEmptyData(data) {
    if (data === null || data === undefined) return true;
    if (data instanceof Object) {
      let t;
      for (t in data) {
        return false;
      }
      return true;
    } else if (data instanceof Array) {
      if (data.length === 0) return true;
      return false;
    }
  },

  /**
   * 深拷贝
   * @param {Object|Array} p
   * @param {Object|Array} c [] or {}
   */
  deepCopy(p, c) {
    c = c || {};
    for (const i in p) {
      if (typeof p[i] === 'object') {
        c[i] = p[i] ? (p[i] && p[i].constructor === Array ? [] : {}) : p[i];
        this.deepCopy(p[i], c[i]);
      } else {
        c[i] = p[i];
      }
    }
    return c;
  },

  /**
   * 随机生成唯一 ID
   * @param {Number}
   */
  generateId(len = 4) {
    return Number(
      Math.random()
        .toString()
        .substr(3, len) + Date.now()
    ).toString(36);
  },

  /**
   * 优化遍历，数组去重
   * @param {Array} array
   */
  uniq(array, key) {
    const temp = [];
    const index = [];
    const l = array.length;
    for (let i = 0; i < l; i++) {
      for (let j = i + 1; j < l; j++) {
        if (array[i][key] && array[i][key] === array[j][key]) {
          i++;
          j = i;
        }
      }
      temp.push(array[i]);
      index.push(i);
    }
    return temp;
  }
};

export default utils;
