import config from './config';

const Api = {
  /**
   * 获取系统信息
   * @param {String} sysCode 系统code
   */
  getSystemInfo(sysCode) {
    return config.doGetPromise('/index/getSystemCfgBeforeLogin', {sysCode});
  },

  login(data) {
    return config.doPostPromise('/index/login', data);
  },

  checkLogin() {
    return config.doGetPromise('/index/checkLogin', {}, { retry: 0 });
  },

  logout() {
    return config.doGetPromise('/index/logout', {});
  },

  getAdminDivisionTree() {
    return config.doGetPromise('/administrativeDivisions/getAdministrativeDivisionTree');
  },

  /**
   * 获取用户权限下的系统模块功能
   * @param {String} systemId   子系统Id
   * @param {type}        类型：0-菜单，1-功能点
   */
  getUserModulesTreeBySystemId(systemId, type = 0) {
    return config.doGetPromise('/systemModule/getUserModulesTree', {
      systemId,
      type
    });
  },

  /**
   * 获取系统模块功能
   * @param {String} id    子系统Id
   * @param {Number(0,1)}  类型：0-菜单，1-功能点，默认是0
   */
  getSystemAllModules(id, type = 0) {
    return config.doGetPromise('/systemModule/getSystemAllModulesTree', {
      systemId: id,
      type
    });
  },

  /**
   * 获取组织结构的树状信息
   * @param {Number} type 类型，1：只返回部门岗位信息；  2：返回部门岗位与人员信息； 3：返回角色信息； 4：返回部门（无岗位）；5：返回人员；其他：返回所有组织项信息
   * @param {Number} valid 是否可用， -1:审核中   1:可用(第一次登录，需要修改密码)  2:可用(非第一次登录，不需要修改密码)
   */
  getOrganTree(type, valid) {
    return config.doGetPromise('/organization/manager/getOrganTree', {
      type: type,
      valid: valid
    });
  },

  // 获取代码字典
  getChildItemByRootCode(data) {
    return config.doGetPromise('/codeDict/getChildItemByRootCode', data);
  },

  /**
   * 获取用户拥有的业务
   * @param {String} userId
   */
  getBusinessTree(userId) {
    return config.doGetPromise('/business/system/businessDefTreeByUserId', {
      userId: userId
    });
  },

  /**
   * 获取个人配置
   * @param {String} type 配置信息类型；其中1:个人配置 ,2:业务配置,3:功能配置,4:主题配置
   */
  getUserConfigTheme(type = 4) {
    return config.doGetPromise('/personalConfigure/listAllInfo', {
      infoType: type
    });
  },

  /**
   * 根据模块查询用户的权限
   */
  getUserAuthories(moduleId) {
    return config.doGetPromise('/authorityManage/queryUserSysAuthorizeInfoList', {
      moduleId
    });
  }
};

export default Api;
