import store from '@/store';
import router from '@/router';

/**
 * 菜单表达式函数
 * 操作标签页
 */
export default {
  /**
 * 全局打开新标签页方法
 * 利用的是store, id作为唯一性检查，没有id就会自动生成id
 * @param {Object} data 组件的对象，比如 {id:'', name:'组织构架管理', componentName:'frameworkManage'}
 * @param {Any} param 绑定到数据里的param
 */
  openTab(data, param) {
    console.log(data);
    const componentName = data.componentName || data.router;

    // 判断是否为http开头的外链
    if (componentName.indexOf('http') === 0) {
      router.push({
        name: 'appIframe',
        params: {
          url: componentName
        }
      });
      return;
    }

    // 菜单模块ID赋值，权限通过模块ID获取的
    if (!data.moduleId) {
      const menuList = store.getters['menu/menuList'];

      if (menuList.length > 0) {
        let menu;
        const fn = (data) => {
          const len = data.length;
          for (let i = 0; i < len; i++) {
            // console.log(data[i].router, componentName)
            if (data[i].router === componentName) {
              menu = data[i];
              break;
            } else {
              if (data[i].children && data[i].children.length > 0) {
                fn(data[i].children);
              }
            }
          }
        };
        fn(menuList);

        // 模块id赋值
        if (menu) data.moduleId = menu.moduleId;
      }
    }

    data.componentName = componentName;

    data.param = param || {};

    router.push({
      name: data.componentName,
      params: {
        moduleId: data.moduleId,
        ...param
      }
    });
  },
  /**
   * 打开一个外部链接的标签
   * @param {String} name 标签名称
   * @param {String} url 外部URL
   * @param {Boolean|String} only 布尔值为true时，是固定使用externalLinkTab---1打开页面，当是string字符串时，自定义打开固定标签页
   */
  openExternalLinkTab(name, url, only) {
    /* const id = (typeof only === 'boolean' && only)
      ? 'externalLinkTab---1'
      : (typeof only === 'string' && only)
        ? only : ''; */
    router.push({
      name: 'appIframe',
      params: {
        name,
        url: url
      }
    });
  }
};
