import store from '@/store';
import { Notification } from 'element-ui';

/**
 * 系统表达式函数
 * 获取系统，用户， 全局通知等信息
 */
export default {
  /**
   * 获取用户信息
   * @returns {Object | null}
   */
  getUser() {
    return store.state.userInfo || null;
  },
  /**
   * 获取用户身份
   * @returns {String}
   */
  getUserName() {
    return store.state.userInfo ? store.state.userInfo.RealName : '';
  },
  /**
   * 获取系统信息
   * @returns {Object}
   */
  getSystemInfo() {
    return store.state.platformInfo || null;
  },
  /**
   * 获取用户身份
   * @returns {String} admin | none
   */
  getUserIdentity() {
    return store.state.userIdentity || '';
  },
  /**
   * 公共提示方法，一般用于组件内保存提交时提示
   * @param {object} options 和element-ui Notification组件属性一样
   * 例如：object = {type: 'success', title: '操作成功', message: '页面保存成功'}
   */
  notification(options) {
    const {
      customClass = 'custom-notification',
      position = 'bottom-right',
      ...opts
    } = options;

    const _opts = {
      customClass,
      position,
      ...opts
    };

    Notification(_opts);
  }
};
