import Vue from 'vue';
import Router from 'vue-router';
import routes from './routes';
import { removeLoading, getSystemInfo } from '../utils/global';
import Api from '../api';
import store from '../store';

const vm = new Vue();
Vue.use(Router);

const router = new Router({
  // mode: 'history',
  routes
});

function nextLogin(query) {
  router.replace({
    name: 'Login',
    query: query
  });
}

function filterRouteLogin(route) {
  return ['Login', 'LoginDialog'].indexOf(route.name) >= 0;
}

function checkLogin(next) {
  // 检查登录
  Api.checkLogin().then(res => {
    if (res.status === 0) {
      const data = res.data;
      // vuex store
      const userState = {
        ...data.loginInfo,
        userId: data.userId
      };
      // 设置vuex userInfo
      store.dispatch('setUserInfo', userState);
      next();
    } else {
      store.dispatch('setUserInfo', {});
      nextLogin();
    }
  }).catch(() => {
    store.dispatch('setUserInfo', {});
    nextLogin();
  });
}

router.beforeEach((to, from, next) => {
  if (vm.$Progress) {
    if (to.meta.progress !== undefined) {
      const meta = to.meta.progress;
      // parse meta tags
      vm.$Progress.parseMeta(meta);
    }
    vm.$Progress.start();
  }

  if (to.name === '404' || to.name === 'Unfound') {
    removeLoading();
    next();
    return;
  }

  if (filterRouteLogin(to)) {
    next();
    return;
  }

  if (store.state.platformInfo &&
    store.state.platformInfo.systemId &&
    to.query.sysCode === from.query.sysCode) {
    checkLogin(next);
  } else {
    const sysCode = to.query.sysCode;
    getSystemInfo(sysCode).then(_ => {
      checkLogin(next);
    }).catch(err => {
      if (err.status === 1 || err.status === 2) {
        // 获取系统信息错误
        router.replace({
          name: 'Unfound',
          query: {
            sysCode
          }
        });
      } else {
        router.replace({
          name: 'Login',
          query: {
            sysCode
          }
        });
      }
    });
  }
});

router.afterEach(() => {
  vm.$Progress && vm.$Progress.finish();
});

export default router;
