import Main from '@/views/Main';
import Login from '@/views/login/Login';
import ErrorPage from '@/components/404';
import UnfoundSys from '@/components/UnfoundSys';
import store from '@/store';
import Api from '@/api';
import appHome from '@/views/common/appHome';
import appIframe from '@/views/common/AppIframe.vue';

// 处理加载routes文件夹路由注入
let asyncComponents = [];
const files = require.context('./routes', false, /\.js$/);
files.keys().forEach(key => {
  asyncComponents = asyncComponents.concat(files(key).default);
});

function checkLogin() {
  return new Promise((resolve, reject) => {
    Api.checkLogin().then(res => {
      if (res.status === 0) {
        const data = res.data;
        // vuex store
        const userState = {
          ...data.loginInfo,
          userId: data.userId
        };
        // 设置vuex userInfo
        store.dispatch('setUserInfo', userState);
        // 路由跳转
        resolve();
      } else {
        store.dispatch('setUserInfo', {});
        reject(res);
      }
    }).catch((err) => {
      store.dispatch('setUserInfo', {});
      reject(err);
    });
  });
}

export default [
  {
    path: '/',
    name: 'Main',
    component: Main,
    redirect: '/home',
    props: (route) => ({ sysId: route.query.sysId }),
    children: [
      {
        path: 'home',
        name: 'Home',
        component: appHome
      }, {
        path: 'appIframe',
        name: 'appIframe',
        component: appIframe
      }, {
        path: 'appMessage',
        name: 'appMessage',
        component: () => import('@/views/common/message')
      }, {
        path: 'configurePage/:moduleId',
        name: 'configurePage',
        component: () => import('@/views/common/ConfigurePage.vue')
      },
      ...asyncComponents
    ]
  }, {
    path: '/login',
    name: 'Login',
    component: Login,
    meta: {
      igonreLogin: true
    },
    beforeEnter: (to, from, next) => {
      checkLogin().then(_ => {
        next({
          name: 'Main',
          query: to.query
        });
      }).catch(_ => {
        next();
      });
    }
  }, {
    path: '/unfound',
    name: 'Unfound',
    component: UnfoundSys
  }, {
    path: '*',
    name: '404',
    component: ErrorPage
  }
];
