import Vue from 'vue';
import Vuex from 'vuex';
const packageConfig = require('../../package.json');

Vue.use(Vuex);

const modules = {};
const files = require.context('./modules', false, /\.js$/);

files.keys().forEach(key => {
  modules[key.replace(/(\.\/|\.js)/g, '')] = files(key).default;
});

const store = new Vuex.Store({
  namespaced: true,

  modules,

  state: {
    platformInfo: {
      moduleId: '#',
      systemId: ''/* '00000000-0000-0015-0001-000000000001' */,
      name: 'Smart Web 平台',
      // name: '国土测绘院政务系统',
      disabled: true,
      version: packageConfig.version || ''
    },
    unreadMessage: 0,           // 未读消息
    userInfo: {
      userId: '',
      SysId: '',
      OrganName: '',
      RealName: ''
    },
    userIdentity: 'none',       // 用户身份，admin, none
    theme: {
      format: 'left-right',
      themeColor: 'deep'
    }
  },

  mutations: {
    setUserInfo(state, payload) {
      state.userInfo = payload;
    },
    setUserIdentity(state, payload) {
      state.userIdentity = payload;
    },
    setTheme(state, payload) {
      state.theme = payload;
    },
    setUnreadMessage(state, count) {
      state.unreadMessage = count;
    }
  },

  actions: {
    setUserInfo(context, payload) {
      context.commit('setUserInfo', payload);

      if (payload && payload.Qua === 99) {
        context.commit('setUserIdentity', 'admin');
      } else {
        context.commit('setUserIdentity', 'none');
      }
    },
    setTheme({ commit }, payload) {
      commit('setTheme', payload);
    },
    setUnreadMessage(context, count) {
      context.commit('setUnreadMessage', count);
    }
  }
});

export default store;
