import Api from '@/api';
/**
 * 组件混入统一权限
 * data注入userAuthories存储接口或者管理权限
 * userAuthories = {
 *    identity: 'admin',  // 或者无
 *    defaultAuthority: '2',    // 2-只读，4-操作，8-管理（后台约束）
 *    expandAuthorities: []         // 扩展的权限列表
 * }
 */
export default {
  computed: {
    userInfo() {
      return this.$store.state.userInfo;
    },
    defaultAuthority() {
      return this.userAuthories ? this.userAuthories.defaultAuthority : '';
    },
    expandAuthorities() {
      return this.userAuthories ? this.userAuthories.expandAuthorities : [];
    }
  },
  data() {
    return {
      userAuthories: null
    };
  },

  watch: {
    userInfo: {
      deep: true,
      handler(val) {
        if (val && val.userId) {
          this.initPermission();
        }
      }
    },
    userAuthories: {
      deep: true,
      handler(val) {
        this.hanldePermission && this.hanldePermission(val);
      }
    }
  },

  created() {
    this.initPermission();
  },

  methods: {
    initPermission() {
      // 超级管理员特殊处理
      if (this.$store.state.userIdentity === 'admin') {
        this.userAuthories = {
          defaultAuthority: 8,
          expandAuthorities: []
        };
        return;
      }
      /**
       * 一些模块的控件过滤
       * 例如：没有存在的菜单的项的路由组件，不作权限控件
       */
      if ([].indexOf(this.$route.name) >= 0
      ) {
        return;
      }

      // 判断是否有moduleId，一般首页没有
      if (!this.$route.params.moduleId) return;
      Api.getUserAuthories(this.$route.params.moduleId).then(res => {
        if (res.status === 0) {
          this.userAuthories = {
            defaultAuthority: res.data.defaultSysAuthorize,
            expandAuthorities: res.data.sysAuthorizeList
          };
        }
      });
    }
  }
};
