module.exports = {
  root: true,
  env: {
    node: true
  },
  'extends': [
    'plugin:vue/essential',
    '@smart/standard'
  ],
  plugins: [
    'vue'
  ],
  rules: {
    'comma-dangle': ['error', {
      'arrays': 'never',
      'objects': 'ignore',
      'imports': 'ignore',
      'exports': 'ignore',
      'functions': 'ignore'
    }],
    'no-multi-spaces': ['error', {
      'ignoreEOLComments': true
    }],
    'no-unused-vars': [2, { 'args': 'none' }],
    'no-console': process.env.NODE_ENV === 'production' ? 'error' : 'off',
    'no-debugger': process.env.NODE_ENV === 'production' ? 'error' : 'off'
  },
  parserOptions: {
    parser: 'babel-eslint'
  }
};
