import axios from 'axios';
import store from '@/store';
import router from '@/router';
import MessageBox from 'element-ui/lib/message-box';

/* const filters = ['webgisService']

const handleFilter = (key) => {
  if (Array.isArray(filters)) {
    filters.forEach(item => {
      if (item === key) {}
    })
  }
} */

/**
 * 登录判断失效
 * 在所有经过axios请求中，拦截到登录失效
 * 
 * @param {Object} response
 */
let isOtherLogin = false;
function loginInterceptor(response) {
  // 9: 此账号在其他地方登陆 
  // 8: 账号登录已经失效
  if (response.data && response.data.status === 8) {
    if (!isOtherLogin) {
      store.dispatch('setUserInfo', {});
      router.replace({
        name: 'LoginDialog',
        query: router.currentRoute.query
      });
      isOtherLogin = false;
      // response.data = null
    }
    return response;
  } else if (response.data && response.data.status === 9) {
    if (!isOtherLogin) {
      isOtherLogin = true;
      store.dispatch('setUserInfo', {});
      MessageBox.alert('该账号在别的地方登录了，请重新登录', '提示', {
        type: 'warning',
        confirmButtonText: '登录',
        callback: action => {
          isOtherLogin = false;
          if (action === 'confirm') {
            router.replace({
              name: 'LoginDialog',
              query: router.currentRoute.query
            });
          }
        }
      });
    }
    return response;
  } else {  
    return response;
  }
}

axios.interceptors.response.use(loginInterceptor);
