import config from '@config/config';

const Api = {
  ...config,

  login(data) {
    return config.doPostPromise('/index/login', data);
  },

  checkLogin() {
    return config.doGetPromise('/index/checkLogin', {}, { retry: 0 });
  },

  logout() {
    return config.doGetPromise('/index/logout', {});
  },

  /**
   *
   * @param {*} businessDefinitionId
   * @param {*} taskId
   */
  getBusinessStartForm(businessDefinitionId, taskId) {
    return config.doGetPromise(
      '/v1.1.0/workflow/workflowForm/getBusinessStartForm',
      {
        businessDefinitionId,
        taskId
      }
    );
  },

  /**
   * 获取渲染的表单数据
   * @param {String} taskId
   * @param {String} linkId linkInstanceId
   * @param {String} linkKey linkDefinitionKey
   */
  renderFormByTaskId(taskId, linkId, linkKey) {
    return config.doGetPromise(
      '/v1.1.0/workflow/workflowForm/renderFormByTaskId',
      {
        taskId: taskId,
        linkInstanceId: linkId,
        linkDefinitionKey: linkKey
      }
    );
  },

  /**
   * 办结工作渲染表单
   * @param {String} processId
   */
  renderFinishForm(processId) {
    return config.doGetPromise(
      '/v1.1.0/workflow/workflowForm/renderFinishForm',
      {
        historyProcessInstanceId: processId
      }
    );
  },

  /**
   * 通过获取表单ID获取表单模板
   * @param {string} formid 表单ID
   */
  getForm(formid) {
    return config.doGetPromise('/v1.1.0/form/getForm', {
      rid: formid
    });
  },

  getAdminDivisionTree() {
    return config.doGetPromise(
      '/administrativeDivisions/getAdministrativeDivisionTree'
    );
  },

  /**
   * 获取用户权限下的系统模块功能
   * @param {String} id 子系统Id
   */
  getSystemAllModules(id) {
    return config.doGetPromise(
      '/systemModule/privilege/getUserModulesTreeBySystemId',
      { systemId: id }
    );
  },

  /**
   * 获取组织结构的树状信息
   * @param {Number} type 类型，1：只返回部门岗位信息；  2：返回部门岗位与人员信息； 3：返回角色信息； 4：返回部门（无岗位）；5：返回人员；其他：返回所有组织项信息
   * @param {Number} valid 是否可用， -1:审核中   1:可用(第一次登录，需要修改密码)  2:可用(非第一次登录，不需要修改密码)
   */
  getOrganTree(type, valid) {
    return config.doGetPromise('/organization/manager/getOrganTree', {
      type: type,
      valid: valid
    });
  },

  // 获取代码字典
  getChildItemByRootCode(data) {
    return config.doGetPromise(
      '/codeDict/getChildItemByRootCode',
      data
    );
  },

  /**
   * 提交前检查是否有下个环节处理人
   * @param {string} taskId
   * @param {FormData} data 表单数据
   */
  checkAndSubmitTaskByFormData(taskId, data) {
    return config.doPostPromiseForm('/v1.1.0/workflow/workflowForm/checkAndSubmitTaskByFormData/' +
      taskId, data
    );
  },

  /**
   * 获取转办人的信息
   * @param {string} taskId 流程ID
   */
  getTranformUser(taskId) {
    return config.doGetPromise('/workflow/linkInstance/findLinkInstanceByTaskIdPassto',
      {
        taskId: taskId
      }
    );
  },

  /**
   * 退回 - 获取退回对话框处理人树数据
   * @param {string} currentTaskId
   * @param {string} processDefinitionId
   * @param {string} nextLinkKey
   */
  getRerunPeople(currentTaskId, processDefinitionId, nextLinkKey) {
    return config.doGetPromise(
      '/workflow/workflowForm/getRerunPeople',
      {
        currentTaskId,
        processDefinitionId,
        nextLinkKey
      }
    );
  },

  /**
   * 退回 - 根据任务id获取执行流id(第三步)
   */
  findExecutionIdByTaskId(taskId) {
    return config.doGetPromise(
      '/workflow/execution/findExecutionIdByTaskId',
      {
        taskId
      }
    );
  },

  /**
   * 退回 - 当前环节跳转到指定环节(第四步)
   * @param {*} executionId
   * @param {*} linkDefinitionKey
   * @param {*} rerunReason
   * @param {*} operationType
   * @param {*} isSendbackOldLink
   * @param {*} anotherAssignee
   */
  sendReturnTaks(
    executionId,
    linkDefinitionKey,
    rerunReason = '',
    operationType = 'reRun',
    isSendbackOldLink = 0,
    anotherAssignee
  ) {
    return config.doGetPromise(
      '/v1.1.0/workflow/workflowForm/sendback',
      {
        executionId,
        linkDefinitionKey,
        rerunReason,
        operationType,
        isSendbackOldLink,
        anotherAssignee
      }
    );
  }
};

export default Api;
