const parentExpression = window.parent ? window.parent.$ : null;
const $ = {};

/**
 * 引入平台表达式
 * 扩展表单表达式
 */

// 合并父级表达式
if (parentExpression) {
  Object.keys(parentExpression).forEach(function(key) {
    $[key] = parentExpression[key];
  });
}

/**
 * @example
 * $.form.xxx()
 */
$.form = {
  /**
   * 获取业务受理号
   */
  getBusinessNumber() {
    return window.taskData ? window.taskData.businessNumber : '';
  },
  /**
   * 通过字段名获取表单的值
   * @param {String} field  表单控件绑定字段，如JOB_YWB-RID
   */
  getFormValue(field) {
    const formData = window.formData;
    if (formData) {
      let value = null;
      Object.keys(formData).forEach(key => {
        if (key === field) value = formData[key];
      });
      return value;
    } else {
      return null;
    }
  },
  /**
   * 通过字段名设置表单的值
   * @param {String} field  表单控件绑定字段，如JOB_YWB-RID
   * @param {Any} value  传值
   */
  setFormValue(field, value) {
    const formData = window.formData;
    if (formData) {
      Object.keys(formData).forEach(key => {
        if (key === field) formData[key] = value;
      });
    }
  },
  /**
   * 获取任务ID
   */
  getTaskId() {
    return window.taskData ? window.taskData.taskId : '';
  },
  /**
   * 获取环节ID
   */
  getLinkId() {
    return window.taskData ? window.taskData.linkId : '';
  },
  /**
   * 获取环节KEY
   */
  getLinkKey() {
    return window.taskData ? window.taskData.linkKey : '';
  },
  /**
   * 获取流程实例ID
   */
  getProcessInstanceId() {
    return window.taskData ? window.taskData.processInstanceId : '';
  },
  /**
   * 获取流程定义ID
   */
  getProcessDefinitionId() {
    return window.taskData ? window.taskData.processDefinitionId : '';
  }
};

window.$ = $;
