import { Notification } from 'element-ui';
/**
 * 处理数值，默认返回px单位
 * @param {string|nubmer} val
 * @returns {stirng}
 */
export const handleNumUnit = val => {
  return isNaN(Number(val)) ? val : val + 'px';
};

/**
 * 获取URL参数
 * @param {string} name 参数名
 */
export function getQueryString(name) {
  const reg = new RegExp('(^|&)' + name + '=([^&]*)(&|$)');
  const r = window.location.search.substr(1).match(reg);
  if (r !== null) return unescape(r[2]);
  return null;
}

export function getBusinessDefinitionId() {
  return getQueryString('businessDefinitionId');
}
export function getFormId() {
  return getQueryString('formid');
}
export function getTaskId() {
  return getQueryString('taskId');
}
export function getLinkId() {
  return getQueryString('linkId');
}
export function getLinkKey() {
  return getQueryString('linkKey');
}
export function getFinishForm() {
  return getQueryString('historyProcessInstanceId');
}

/**
 * 统一处理提示
 * @param {string} type success warning error
 * @param {string} message 提示文字
 * @param {string} title 提示标题
 */
export function notification(type, message, title) {
  // Message[type](message)
  title = title || '';
  if (!title) {
    switch (type) {
      case 'success':
        title = '操作成功';
        break;
      case 'info':
        title = '提示';
        break;
      case 'warning':
        title = '操作失败';
        break;
      case 'error':
        title = '操作错误';
        break;
    }
  }

  Notification({
    type: type,
    title: title,
    message: message,
    position: 'top-right'
  });
}

/**
 * 外部页面公共通知方法
 * @param {Object} options 和element-ui Notification组件属性一样
 */
export function outerNotice(options) {
  const parentWin = window.parent;
  parentWin.notification && parentWin.notification(options);
}

/**
 * 打开标签
 * @param {Object} component 组件的对象，比如 {id:'', name:'组织构架管理', componentName:'frameworkManage'}
 * @param {Object} param 参数
 */
export function openTab(component, param) {
  const parentWin = window.parent;
  parentWin.openTab && parentWin.openTab(component, param);
}

/**
 * 关闭标签
 */
export function closeTab() {
  const parentWin = window.parent;
  const tabId = parentWin.currentNavigation.id || '';
  if (tabId) parentWin.removeTab && parentWin.removeTab(tabId);
}

/**
 * 刷新标签页
 */
export function refreshTab(tabId) {
  const parentWin = window.parent;
  tabId =
    tabId ||
    (parentWin.currentNavigation &&
      parentWin.currentNavigation.param &&
      parentWin.currentNavigation.param.parent);
  if (tabId) parentWin.refreshTab && parentWin.refreshTab(tabId);
}

// 设置高级或某此控件需要【数组】、【对象】类型
// 比如upload_list, sign
const checkObjectJson = data => {
  const widgets = ['upload_list', 'sign', 'select', 'approval'];
  if (widgets.includes(data.type)) {
    return data.model;
  } else {
    return '';
  }
};
/**
 * 遍历表单模板数据，返回需要【数组】、【对象】类型控件的models数据
 * @param {Object} formdata
 * @returns {Array} models
 */
export const transformFormData = formdata => {
  if (!formdata.list) return;
  const arr = [];
  const fn = data => {
    data.forEach(item => {
      // console.log(item)
      if (item.type === 'grid') {
        item.columns.forEach(col => {
          fn(col.list);
        });
      } else if (item.type !== 'text' && item.type !== 'button') {
        const model = checkObjectJson(item);
        if (model) arr.push(model);
      }
    });
  };
  fn(formdata.list);
  return arr;
};
