// The Vue build version to load with the `import` command
// (runtime-only or standalone) has been set in webpack.base.conf with an alias.
import Vue from 'vue';
import App from './App';
import router from './router';
import store from './store';
import ElemetUI from 'element-ui';
import SmartWeb from 'smart-web/src/main.js';
import VueProgressBar from 'vue-progressbar';
import './styles/app.scss';
// import 'smart-web/packages/styles/lib/index.css';

import './plugins/registComponents';
import asyncComponents from './plugins/asyncComponents';
import './utils/appinit';
import './utils/window';
import './utils/expression';
import './api/loginInterceptor';

Vue.config.productionTip = false;

Vue.use(ElemetUI, { size: 'medium', zIndex: 4000 });
Vue.use(SmartWeb, {
  baseUrl: process.env.VUE_APP_BASEURL,
  systemId: '00000000-0000-0015-0001-000000000001'
});
Vue.use(asyncComponents);

const vPopts = {
  color: '#8fcdfc',
  failedColor: '#874b4b',
  thickness: '2px',
  transition: {
    speed: '0.1s',
    opacity: '0.3s',
    termination: 300
  },
  autoRevert: true,
  location: 'top',
  inverse: false,
  autoFinish: true
};

Vue.use(VueProgressBar, vPopts);

/* eslint-disable no-new */
new Vue({
  el: '#app',
  router,
  store,
  components: {
    App
  },
  template: '<App/>'
});
