import { extend, cb } from './extend';
import appHome from '@/views/common/appHome';
import errorPage from '@/components/404.vue';

/**
 * 动态异步加载组件，除了必须组件（HOME, 404）
 */
export const asyncComponents = {
  appHome,
  errorPage,
  appMessage: () => import('@/views/common/message').then(cb),
  appIframe: () => import('@/views/common/AppIframe.vue'),
  configurePage: () => import('@/views/common/ConfigurePage.vue').then(cb)
};

/**
 * 注册routes文件夹的路由组件
 */
const files = require.context('./routes', false, /\.js$/);
files.keys().forEach(key => {
  if (typeof files(key).default === 'object') {
    const _obj = files(key).default;
    for (const routeName in _obj) {
      asyncComponents[routeName] = _obj[routeName];
    }
  }
});

const install = (Vue, opts = {}) => {
  Object.keys(asyncComponents).forEach(key => {
    if (typeof asyncComponents[key] === 'object') {
      asyncComponents[key].extends = extend;
    }
    Vue.component(key, asyncComponents[key]);
  });
};

/**
 * 判断异步组件是否已经注册
 * @param {String} str 判断的组件名称
 * @returns Boolean
 */
export const checkAsyncComponents = (str) => {
  let flag = false;
  for (const key in asyncComponents) {
    if (str === key) {
      flag = true;
      break;
    }
  }

  return flag;
};

export const getComponentsName = () => {
  const componentsNames = [];
  for (const key in asyncComponents) {
    componentsNames.push(key);
  }
  return componentsNames;
};

export default install;
