import store from '@/store';
// tab页面混入渲染成功后tab-mounted监听
export const extend = {
  computed: {
    $SMTab() {
      return store.state.currentNavigation;
    }
  },

  watch: {
    '$SMTab.param.reload': function(val, oldVal) {
      if (val && oldVal !== val) {
        this.refresh && this.refresh();
      }
    }
  },
  mounted() {
    this.$emit('tab-mounted');
  }
};

export const cb = (comp) => {
  comp.default.extends = extend;
  return comp;
};

export default extend;
