import Vue from 'vue';
import Tabs from '@/components/tabs';
import Tabpane from '@/components/tab-pane';

/**
 * 注册加载组件
 */
export const registComponents = {
  Tabs,
  Tabpane
};

Object.keys(registComponents).forEach(key => {
  if (registComponents[key].type === 'prototype') {
    Object.keys(registComponents[key]).forEach(item => {
      Vue.prototype[item] = registComponents[key][item];
    });
  } else {
    Vue.use(registComponents[key]);
  }
});
