import Vue from 'vue';
import Router from 'vue-router';
import routes from './routes';
import Api from '../api';
import store from '../store';
import { removeLoading, getSystemInfo } from '../utils/global';

Vue.use(Router);

function nextLogin(to, from, next) {
  next({
    name: 'Login',
    replace: true,
    query: to.query
  });
}

function filterRouteLogin(route) {
  return ['Login', 'LoginDialog'].indexOf(route.name) >= 0;
}
// 判断是否存在用户
/* function isExistUser () {
  return store.state.userInfo && store.state.userInfo.userId
}
// 判断是否存在平台信息
function isExistPlatform () {
  return store.state.platformInfo && store.state.platformInfo.systemId
} */

const router = new Router({
  // mode: 'history',
  routes
});

router.beforeEach((to, from, next) => {
  if (to.name === '404' || to.name === 'Unfound') {
    removeLoading();
    next();
    return;
  }

  function checkLogin() {
    // 检查登录
    Api.checkLogin().then(res => {
      if (res.status === 0) {
        const data = res.data;
        // vuex store
        const userState = {
          ...data.loginInfo,
          userId: data.userId
        };
        // 设置vuex userInfo
        store.dispatch('setUserInfo', userState);
        // 路由跳转
        if (filterRouteLogin(to)) {
          next({
            name: 'Main'
          });
        } else {
          next();
        }
      } else {
        store.dispatch('setUserInfo', {});
        nextLogin(to, from, next);
      }
    }).catch(() => {
      store.dispatch('setUserInfo', {});
      nextLogin(to, from, next);
    });
  }

  // 获取系统信息
  getSystemInfo(to.query.sysCode).then(_ => {
    if (from.meta.igonreLogin) {
      next();
      return;
    }
    if (to.name === 'Main') {
      checkLogin();
    } else {
      next();
    }
  }).catch(err => {
    if (err.status === 1 || err.status === 2) {
      // 获取系统信息错误
      next({
        name: 'Unfound',
        replace: true,
        query: to.query
      });
    } else {
      nextLogin(to, from, next);
    }
  });
});

export default router;
