import Main from '@/views/Main';
import Login from '@/views/login/Login';
import LoginDialog from '@/views/login/LoginDialog';
import ErrorPage from '@/components/404';
import UnfoundSys from '@/components/UnfoundSys';
import store from '@/store';
import Api from '@/api';

function checkLogin() {
  return new Promise((resolve, reject) => {
    Api.checkLogin().then(res => {
      if (res.status === 0) {
        const data = res.data;
        // vuex store
        const userState = {
          ...data.loginInfo,
          userId: data.userId
        };
        // 设置vuex userInfo
        store.dispatch('setUserInfo', userState);
        // 路由跳转
        resolve();
      } else {
        store.dispatch('setUserInfo', {});
        reject(res);
      }
    }).catch((err) => {
      store.dispatch('setUserInfo', {});
      reject(err);
    });
  });
}

export default [
  {
    path: '/',
    name: 'Main',
    component: Main,
    // redirect: '/home',
    props: (route) => ({ sysId: route.query.sysId }),
    children: [{
      path: 'logindialog',
      name: 'LoginDialog',
      component: LoginDialog,
      meta: {
        igonreLogin: true
      }/* ,
      beforeEnter: (to, from, next) => {
        checkLogin().then(_ => {
          next({
            name: 'Main',
            query: to.query
          })
        }).catch(_ => {
          next()
        })
      } */
    }]
  }, {
    path: '/login',
    name: 'Login',
    component: Login,
    meta: {
      igonreLogin: true
    },
    beforeEnter: (to, from, next) => {
      checkLogin().then(_ => {
        next({
          name: 'Main',
          query: to.query
        });
      }).catch(_ => {
        next();
      });
    }
  }, {
    path: '/unfound',
    name: 'Unfound',
    component: UnfoundSys
  }, {
    path: '*',
    name: '404',
    component: ErrorPage
  }
];
